/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class SaturationModificationFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"color", "amount"};

    SaturationModificationFunctionGenerator() {
        super(SaturationModificationFunctionGenerator.createArgumentList(argumentNames, false), "saturate", "desaturate");
    }

    @Override
    public SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        LexicalUnitImpl color = this.checkAndGetColor(function, actualArguments);
        double amount = this.checkAndGetAmount(function, actualArguments);
        double alpha = ColorUtil.getAlpha(color);
        double[] hsl = ColorUtil.colorToHsl(color);
        hsl[1] = "saturate".equals(function.getFunctionName()) ? hsl[1] + amount : hsl[1] - amount;
        hsl[1] = Math.max(0.0, Math.min(100.0, hsl[1]));
        return ColorUtil.createHslaOrHslColor(hsl, alpha, function.getLineNumber(), function.getColumnNumber());
    }

    private LexicalUnitImpl checkAndGetColor(LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem colorItem = SaturationModificationFunctionGenerator.getParam(actualArguments, "color");
        if (!(colorItem instanceof LexicalUnitImpl)) {
            throw new ParseException("The first argument of " + function.getFunctionName() + "() must be a valid color", function);
        }
        LexicalUnitImpl color = (LexicalUnitImpl)colorItem;
        if (!(ColorUtil.isColor(color) || ColorUtil.isRgba(color) || ColorUtil.isHsla(color))) {
            throw new ParseException("The first argument of " + function.getFunctionName() + "() must be a valid color", function);
        }
        return color;
    }

    private double checkAndGetAmount(LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem amountItem = SaturationModificationFunctionGenerator.getParam(actualArguments, "amount");
        if (!LexicalUnitImpl.checkLexicalUnitType(amountItem, 23)) {
            throw new ParseException("The amount argument of " + function.getFunctionName() + "() must be a percentage value", function);
        }
        double amount = amountItem.getContainedValue().getDoubleValue();
        if (amount < 0.0 || amount > 100.0) {
            throw new ParseException("The amount argument of " + function.getFunctionName() + "() must be a percentage value between 0% and 100%", function);
        }
        return amount;
    }
}

