/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.ArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import java.util.ArrayList;

class RectFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"value"};

    RectFunctionGenerator() {
        super(RectFunctionGenerator.createArgumentList(argumentNames, true), "rect");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        ArgumentList actualParams = (ArgumentList)RectFunctionGenerator.getParam(actualArguments, 0);
        ArrayList<SassListItem> resultParams = new ArrayList<SassListItem>();
        for (int i = 0; i < actualParams.size(); ++i) {
            boolean paramOk = true;
            SassListItem item = actualParams.get(i);
            if (!(item instanceof LexicalUnitImpl)) {
                throw new ParseException("Only simple values are allowed as rect() parameters: " + actualParams);
            }
            LexicalUnitImpl lui = (LexicalUnitImpl)item;
            if (lui.getItemType() == 13) {
                if (lui.getIntegerValue() != 0) {
                    paramOk = false;
                }
            } else if (lui.getItemType() == 35) {
                if (!"auto".equals(lui.getStringValue())) {
                    paramOk = false;
                }
            } else if (!LexicalUnitImpl.checkLexicalUnitType(lui, 15, 16, 17, 19, 20, 18, 21, 22)) {
                paramOk = false;
            }
            if (!paramOk) {
                throw new ParseException("The following value is not accepted as a parameter for rect(): " + item);
            }
            resultParams.add(item);
        }
        ActualArgumentList params = new ActualArgumentList(SassList.Separator.COMMA, resultParams);
        if (params.size() == 4) {
            return LexicalUnitImpl.createRect(function.getUri(), function.getLineNumber(), function.getColumnNumber(), params);
        }
        return LexicalUnitImpl.createFunction(function.getUri(), function.getLineNumber(), function.getColumnNumber(), "rect", params);
    }
}

