/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.function.AbstractSingleParameterFunctionGenerator;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;

class QuoteUnquoteFunctionGenerator
extends AbstractSingleParameterFunctionGenerator {
    private static String[] argumentNames = new String[]{"string"};

    QuoteUnquoteFunctionGenerator() {
        super(QuoteUnquoteFunctionGenerator.createArgumentList(argumentNames, false), "quote", "unquote");
    }

    @Override
    protected LexicalUnitImpl computeForParam(LexicalUnitImpl function, LexicalUnitImpl firstParam) {
        if (!LexicalUnitImpl.checkLexicalUnitType(firstParam, 35, 36, 24)) {
            throw new ParseException("The parameter of " + function.getFunctionName() + "() must be a string", firstParam);
        }
        String result = firstParam.printState();
        if ("quote".equals(function.getFunctionName())) {
            if (this.isQuoted(result)) {
                return firstParam;
            }
            return LexicalUnitImpl.createString(firstParam.getUri(), firstParam.getLineNumber(), firstParam.getColumnNumber(), result);
        }
        result = this.unquote(result);
        return LexicalUnitImpl.createIdent(firstParam.getUri(), firstParam.getLineNumber(), firstParam.getColumnNumber(), result);
    }

    private String unquote(String string) {
        if (!this.isQuoted(string)) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    private boolean isQuoted(String string) {
        return string.length() > 1 && (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'');
    }
}

