/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.function.AbstractSingleParameterFunctionGenerator;
import com.inet.sass.parser.LexicalUnitImpl;

class PercentageFunctionGenerator
extends AbstractSingleParameterFunctionGenerator {
    private static final long PERC_PRECISION_FACTOR = 10000000L;

    PercentageFunctionGenerator() {
        super(PercentageFunctionGenerator.createArgumentList(new String[]{"value"}, false), "percentage");
    }

    @Override
    protected LexicalUnitImpl computeForParam(LexicalUnitImpl function, LexicalUnitImpl firstParam) {
        double value = firstParam.getDoubleValue();
        int intValue = (int)Math.round(value *= 1.0E7);
        value = (double)intValue / 100000.0;
        return LexicalUnitImpl.createPercentage(firstParam.getUri(), firstParam.getLineNumber(), firstParam.getColumnNumber(), value);
    }
}

