/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class MixFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"color1", "color2", "weight"};
    private static SassListItem[] defaultValues = new SassListItem[]{null, null, LexicalUnitImpl.createPercentage(null, 0, 0, 50.0)};

    MixFunctionGenerator() {
        super(MixFunctionGenerator.createArgumentList(argumentNames, defaultValues, false), "mix");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        double alpha2;
        double alpha1;
        double a;
        boolean transparent;
        LexicalUnitImpl color1 = this.checkAndGetColor(actualArguments, "color1", function);
        LexicalUnitImpl color2 = this.checkAndGetColor(actualArguments, "color2", function);
        double weight = MixFunctionGenerator.getParam(actualArguments, "weight").getContainedValue().getDoubleValue();
        double p = weight / 100.0;
        double w = p * 2.0 - 1.0;
        boolean bl = transparent = w * (a = (alpha1 = ColorUtil.getAlpha(color1)) - (alpha2 = ColorUtil.getAlpha(color2))) == -1.0;
        if (transparent) {
            return p <= 0.5 ? color2 : color1;
        }
        double w1 = ((w + a) / (1.0 + w * a) + 1.0) / 2.0;
        double w2 = 1.0 - w1;
        int[] rgb1 = ColorUtil.colorToRgb(color1);
        int[] rgb2 = ColorUtil.colorToRgb(color2);
        int[] result = new int[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = (int)Math.round(w1 * (double)rgb1[i] + w2 * (double)rgb2[i]);
        }
        double alpha = alpha1 * p + alpha2 * (1.0 - p);
        return ColorUtil.createRgbaOrHexColor(result, alpha, function.getLineNumber(), function.getColumnNumber());
    }

    private LexicalUnitImpl checkAndGetColor(FormalArgumentList actualArguments, String argName, LexicalUnitImpl function) {
        SassListItem colorItem = MixFunctionGenerator.getParam(actualArguments, argName);
        if (!(colorItem instanceof LexicalUnitImpl)) {
            throw new ParseException("The color arguments of mix() must be valid colors. Actual argument: " + colorItem.toString(), function);
        }
        LexicalUnitImpl color = (LexicalUnitImpl)colorItem;
        if (!(ColorUtil.isColor(color) || ColorUtil.isRgba(color) || ColorUtil.isHsla(color))) {
            throw new ParseException("The color arguments of mix() must be valid colors. Actual argument: " + colorItem.toString(), function);
        }
        return color;
    }
}

