/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.ArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;

class MinMaxFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"numbers"};

    MinMaxFunctionGenerator() {
        super(MinMaxFunctionGenerator.createArgumentList(argumentNames, true), "min", "max");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        ArgumentList params = (ArgumentList)MinMaxFunctionGenerator.getParam(actualArguments, 0);
        if (params.size() == 0) {
            throw new ParseException("The function " + function.getFunctionName() + " requires at least one parameter", function);
        }
        LexicalUnitImpl result = this.getParam(function, params.get(0));
        for (int i = 1; i < params.size(); ++i) {
            LexicalUnitImpl value = this.getParam(function, params.get(i));
            if ("min".equals(function.getFunctionName())) {
                if (!(value.getDoubleValue() < result.getDoubleValue())) continue;
                result = value;
                continue;
            }
            if (!(value.getDoubleValue() > result.getDoubleValue())) continue;
            result = value;
        }
        return result;
    }

    private LexicalUnitImpl getParam(LexicalUnitImpl function, SassListItem param) {
        if (!(param instanceof LexicalUnitImpl) || !((LexicalUnitImpl)param).isNumber()) {
            throw new ParseException("The parameters to the function " + function.getFunctionName() + " must be numerical", param);
        }
        return (LexicalUnitImpl)param;
    }
}

