/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;

class ListNthFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"list", "n"};

    ListNthFunctionGenerator() {
        super(ListNthFunctionGenerator.createArgumentList(argumentNames, false), "nth");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem nAsItem;
        SassListItem listAsItem = ListNthFunctionGenerator.getParam(actualArguments, "list");
        if (!(listAsItem instanceof SassList)) {
            listAsItem = new SassList(listAsItem);
        }
        if ((nAsItem = ListNthFunctionGenerator.getParam(actualArguments, "n")).getItemType() != 13) {
            throw new ParseException("The second parameter of nth() must be an integer. Actual value: " + nAsItem);
        }
        SassList list = (SassList)listAsItem;
        int n = ((LexicalUnitImpl)nAsItem).getIntegerValue();
        if (n < 1 || n > list.size()) {
            throw new ParseException("Index out of range for the function nth(). List: " + list + ", index: " + n);
        }
        return list.get(n - 1);
    }
}

