/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;

abstract class ListFunctionGenerator
extends AbstractFunctionGenerator {
    ListFunctionGenerator(FormalArgumentList formalArguments, String ... functionNames) {
        super(formalArguments, functionNames);
    }

    protected SassList.Separator getAutoSeparator(SassList firstList, SassList secondList) {
        if (firstList.size() > 1) {
            return firstList.getSeparator();
        }
        if (secondList.size() > 1) {
            return secondList.getSeparator();
        }
        return SassList.Separator.SPACE;
    }

    protected SassList.Separator getAutoSeparator(SassList firstList) {
        if (firstList.size() > 1) {
            return firstList.getSeparator();
        }
        return SassList.Separator.SPACE;
    }

    protected SassList.Separator getSeparator(SassListItem separatorItem) {
        if (!(separatorItem instanceof LexicalUnitImpl)) {
            throw new ParseException("The separator of " + this.getFunctionNames()[0] + "() must be one of 'auto', 'comma', 'space'. Actual value: " + separatorItem);
        }
        String sepString = ((LexicalUnitImpl)separatorItem).getStringValue();
        if ("comma".equals(sepString)) {
            return SassList.Separator.COMMA;
        }
        if ("space".equals(sepString)) {
            return SassList.Separator.SPACE;
        }
        if (!"auto".equals(sepString)) {
            throw new ParseException("The separator of " + this.getFunctionNames()[0] + "() must be one of 'auto', 'comma', 'space'. Actual value: " + sepString);
        }
        return null;
    }

    protected SassList asList(SassListItem item) {
        return item instanceof SassList ? (SassList)item : new SassList(item);
    }
}

