/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class InvertFunctionGenerator
extends AbstractFunctionGenerator {
    InvertFunctionGenerator() {
        super(InvertFunctionGenerator.createArgumentList(new String[]{"color", "weight"}, false), "invert");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        int[] rgb;
        LexicalUnitImpl color = (LexicalUnitImpl)InvertFunctionGenerator.getParam(actualArguments, "color");
        if (color == null) {
            throw new ParseException("Missing argument $color. for function 'invert' ", function);
        }
        if (color.isNumber()) {
            return function;
        }
        SassListItem weightParam = InvertFunctionGenerator.getParam(actualArguments, "weight");
        double weight = 1.0;
        if (weightParam != null) {
            switch (weightParam.getItemType()) {
                case 23: {
                    weight = ((LexicalUnitImpl)weightParam).getDoubleValue() / 100.0;
                    break;
                }
                case 13: 
                case 14: {
                    weight = ((LexicalUnitImpl)weightParam).getDoubleValue();
                }
            }
        }
        if ((rgb = ColorUtil.colorToRgb(color)) == null) {
            throw new ParseException("The function 'invert' requires a color as its first parameter: " + color, function);
        }
        int[] newRgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            int val = rgb[i];
            newRgb[i] = (int)Math.round((double)val * (1.0 - weight) + (double)(255 - val) * weight);
        }
        return ColorUtil.createHexColor(function.getUri(), function.getLineNumber(), function.getColumnNumber(), newRgb);
    }

    @Override
    protected boolean checkForUnsetParameters() {
        return false;
    }
}

