/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.expression.BinaryOperator;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.function.SCSSFunctionGenerator;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;

class IfFunctionGenerator
implements SCSSFunctionGenerator {
    private static String[] argumentNames = new String[]{"condition", "if-true", "if-false"};
    private String[] functionNames;
    private FormalArgumentList arguments = AbstractFunctionGenerator.createArgumentList(argumentNames, false);

    IfFunctionGenerator() {
        this.functionNames = new String[]{"if"};
    }

    @Override
    public String[] getFunctionNames() {
        return this.functionNames;
    }

    @Override
    public SassListItem compute(ScssContext context, LexicalUnitImpl function) {
        FormalArgumentList functionArguments;
        ActualArgumentList args = function.getParameterList();
        try {
            functionArguments = this.arguments.replaceFormalArguments(args, true);
        }
        catch (ParseException e) {
            throw new ParseException("Error in parameters of function " + function.getFunctionName() + "(), line " + function.getLineNumber() + ", column " + function.getColumnNumber() + ": [" + e.getMessage() + "]");
        }
        return this.computeForArgumentList(context, function, functionArguments);
    }

    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem firstParam = AbstractFunctionGenerator.getParam(actualArguments, "condition").evaluateFunctionsAndExpressions(context, true);
        if (BinaryOperator.isTrue(firstParam)) {
            return AbstractFunctionGenerator.getParam(actualArguments, "if-true").evaluateFunctionsAndExpressions(context, true);
        }
        return AbstractFunctionGenerator.getParam(actualArguments, "if-false").evaluateFunctionsAndExpressions(context, true);
    }
}

