/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.function.AbstractSingleParameterFunctionGenerator;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.util.ColorUtil;

class GrayscaleFunctionGenerator
extends AbstractSingleParameterFunctionGenerator {
    private static String[] argumentNames = new String[]{"color"};

    GrayscaleFunctionGenerator() {
        super(GrayscaleFunctionGenerator.createArgumentList(argumentNames, false), "grayscale");
    }

    @Override
    protected LexicalUnitImpl computeForParam(LexicalUnitImpl function, LexicalUnitImpl firstParam) {
        if (ColorUtil.isColor(firstParam) || ColorUtil.isRgba(firstParam) || ColorUtil.isHsla(firstParam)) {
            double[] hsl = ColorUtil.colorToHsl(firstParam);
            hsl[1] = 0.0;
            double alpha = ColorUtil.getAlpha(firstParam);
            return ColorUtil.createHslaOrHslColor(hsl, alpha, firstParam.getLineNumber(), firstParam.getColumnNumber());
        }
        if (firstParam.isNumber()) {
            return function;
        }
        throw new ParseException("The argument of grayscale() must be a valid color or number", firstParam);
    }
}

