/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class AlphaFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"color"};

    AlphaFunctionGenerator() {
        super(AlphaFunctionGenerator.createArgumentList(argumentNames, false), "alpha", "opacity");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        double opacity;
        LexicalUnitImpl color = (LexicalUnitImpl)AlphaFunctionGenerator.getParam(actualArguments, "color");
        if (color.isNumber()) {
            return function;
        }
        if (ColorUtil.isRgba(color) || ColorUtil.isHsla(color)) {
            ActualArgumentList parameterList = color.getParameterList();
            SassListItem last = parameterList.get(parameterList.size() - 1);
            opacity = ((LexicalUnitImpl)last).getDoubleValue();
        } else if (ColorUtil.isColor(color)) {
            opacity = 1.0;
        } else {
            throw new ParseException("The function " + function.getFunctionName() + " requires a color as its first parameter: " + color, function);
        }
        return LexicalUnitImpl.createNumber(function.getUri(), function.getLineNumber(), function.getColumnNumber(), opacity);
    }
}

