/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class AdjustColorFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"color", "red", "green", "blue", "hue", "saturation", "lightness", "alpha"};

    @Override
    protected boolean checkForUnsetParameters() {
        return false;
    }

    AdjustColorFunctionGenerator() {
        super(AdjustColorFunctionGenerator.createArgumentList(argumentNames, false), "adjust-color", "scale-color");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        Object[] adjustBy;
        String functionName = function.getFunctionName();
        this.checkParams(function, actualArguments);
        LexicalUnitImpl color = this.getColor(function, actualArguments);
        double alpha = 1.0;
        if (ColorUtil.isRgba(color) || ColorUtil.isHsla(color)) {
            int lastIndex = color.getParameterList().size() - 1;
            alpha = color.getParameterList().get(lastIndex).getContainedValue().getDoubleValue();
        }
        if ((adjustBy = this.getAdjustments(function, actualArguments))[6] != null) {
            if ("adjust-color".equals(functionName)) {
                alpha += ((Double)adjustBy[6]).doubleValue();
            } else {
                double diff = (Double)adjustBy[6] > 0.0 ? 1.0 - alpha : alpha;
                double adjustAmount = diff * (Double)adjustBy[6] / 100.0;
                alpha += adjustAmount;
            }
            alpha = Math.min(1.0, Math.max(0.0, alpha));
        }
        boolean adjustRGB = this.anySet(adjustBy, 0, 3);
        boolean adjustHsl = this.anySet(adjustBy, 3, 6);
        if (adjustRGB && adjustHsl) {
            throw new ParseException("The function adjust-color cannot modify both RGB and HSL values", function);
        }
        if (adjustRGB) {
            int[] rgb = ColorUtil.colorToRgb(color);
            if ("adjust-color".equals(functionName)) {
                this.adjustRgb(rgb, (Double[])adjustBy);
            } else {
                this.scaleRgb(rgb, (Double[])adjustBy);
            }
            return ColorUtil.createRgbaOrHexColor(rgb, alpha, function.getLineNumber(), function.getColumnNumber());
        }
        if (adjustHsl) {
            double[] hsl = ColorUtil.colorToHsl(color);
            if ("adjust-color".equals(functionName)) {
                this.adjustHsl(hsl, (Double[])adjustBy);
            } else {
                this.scaleHsl(hsl, (Double[])adjustBy);
            }
            return ColorUtil.createHslaOrHslColor(hsl, alpha, function.getLineNumber(), function.getColumnNumber());
        }
        if (ColorUtil.isHsla(color) || ColorUtil.isHslColor(color)) {
            return ColorUtil.createHslaOrHslColor(ColorUtil.colorToHsl(color), alpha, function.getLineNumber(), function.getColumnNumber());
        }
        return ColorUtil.createRgbaOrHexColor(ColorUtil.colorToRgb(color), alpha, function.getLineNumber(), function.getColumnNumber());
    }

    private void scaleHsl(double[] hsl, Double[] adjustBy) {
        for (int i = 1; i < 3; ++i) {
            double newValue;
            Double adjustment = adjustBy[3 + i];
            if (adjustment == null) continue;
            double diff = adjustment > 0.0 ? 100.0 - hsl[i] : hsl[i];
            double adjustAmount = diff * adjustment / 100.0;
            hsl[i] = newValue = hsl[i] + adjustAmount;
        }
    }

    private void adjustHsl(double[] hsl, Double[] adjustBy) {
        hsl[0] = hsl[0] + (adjustBy[3] == null ? 0.0 : adjustBy[3]);
        hsl[0] = (hsl[0] % 360.0 + 360.0) % 360.0;
        hsl[1] = hsl[1] + (adjustBy[4] == null ? 0.0 : adjustBy[4]);
        hsl[1] = Math.min(100.0, Math.max(0.0, hsl[1]));
        hsl[2] = hsl[2] + (adjustBy[5] == null ? 0.0 : adjustBy[5]);
        hsl[2] = Math.min(100.0, Math.max(0.0, hsl[2]));
    }

    private void scaleRgb(int[] rgb, Double[] adjustBy) {
        for (int i = 0; i < 3; ++i) {
            if (adjustBy[i] == null) continue;
            int diff = adjustBy[i] > 0.0 ? 255 - rgb[i] : rgb[i];
            double adjustAmount = (double)diff * adjustBy[i] / 100.0;
            double newValue = (double)rgb[i] + adjustAmount;
            rgb[i] = (int)newValue;
        }
    }

    private void adjustRgb(int[] rgb, Double[] adjustBy) {
        rgb[0] = (int)((double)rgb[0] + (adjustBy[0] == null ? 0.0 : adjustBy[0]));
        rgb[0] = Math.min(255, Math.max(0, rgb[0]));
        rgb[1] = (int)((double)rgb[1] + (adjustBy[1] == null ? 0.0 : adjustBy[1]));
        rgb[1] = Math.min(255, Math.max(0, rgb[1]));
        rgb[2] = (int)((double)rgb[2] + (adjustBy[2] == null ? 0.0 : adjustBy[2]));
        rgb[2] = Math.min(255, Math.max(0, rgb[2]));
    }

    private LexicalUnitImpl getColor(LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem resultItem = AdjustColorFunctionGenerator.getParam(actualArguments, "color");
        if (!(resultItem instanceof LexicalUnitImpl)) {
            throw new ParseException("The color argument must represent a valid color", function);
        }
        LexicalUnitImpl result = (LexicalUnitImpl)resultItem;
        if (!(ColorUtil.isColor(result) || ColorUtil.isRgba(result) || ColorUtil.isHsla(result))) {
            throw new ParseException("The color argument must represent a valid color", function);
        }
        return result;
    }

    private Double[] getAdjustments(LexicalUnitImpl function, FormalArgumentList actualArguments) {
        Double[] result = new Double[7];
        for (int i = 0; i < 7; ++i) {
            SassListItem valueItem = AdjustColorFunctionGenerator.getParam(actualArguments, i + 1);
            if (valueItem == null) continue;
            if (!(valueItem instanceof LexicalUnitImpl) || !((LexicalUnitImpl)valueItem).isNumber()) {
                throw new ParseException("The parameters of adjust-color must be numeric values", function);
            }
            result[i] = ((LexicalUnitImpl)valueItem).getDoubleValue();
        }
        return result;
    }

    private void checkParams(LexicalUnitImpl function, FormalArgumentList actualArguments) {
        for (int i = 1; i < argumentNames.length; ++i) {
            SassListItem value = AdjustColorFunctionGenerator.getParam(actualArguments, i);
            if (!"scale-color".equals(function.getFunctionName()) || value == null || value instanceof LexicalUnitImpl && LexicalUnitImpl.checkLexicalUnitType(value, 23)) continue;
            throw new ParseException("The parameters of scale-color must be percentage values", function);
        }
        if ("scale-color".equals(function.getFunctionName()) && AdjustColorFunctionGenerator.getParam(actualArguments, "hue") != null) {
            throw new ParseException("There is no parameter hue for scale-color", function);
        }
    }

    private boolean anySet(Object[] values, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (values[i] == null) continue;
            return true;
        }
        return false;
    }
}

