/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.SCSSFunctionGenerator;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import java.util.ArrayList;

public abstract class AbstractFunctionGenerator
implements SCSSFunctionGenerator {
    private String[] functionNames;
    private FormalArgumentList arguments;

    public AbstractFunctionGenerator(FormalArgumentList arguments, String ... functionNames) {
        this.functionNames = functionNames;
        this.arguments = arguments;
    }

    @Override
    public String[] getFunctionNames() {
        return this.functionNames;
    }

    protected FormalArgumentList getArguments() {
        return this.arguments;
    }

    @Override
    public SassListItem compute(ScssContext context, LexicalUnitImpl function) {
        FormalArgumentList functionArguments;
        ActualArgumentList args = function.getParameterList().expandVariableArguments();
        try {
            functionArguments = this.arguments.replaceFormalArguments(args, this.checkForUnsetParameters());
        }
        catch (ParseException e) {
            ParseException ex = new ParseException("Error in parameters of function " + function.getFunctionName(), function);
            ex.initCause(e);
            throw ex;
        }
        return this.computeForArgumentList(context, function, functionArguments);
    }

    protected abstract SassListItem computeForArgumentList(ScssContext var1, LexicalUnitImpl var2, FormalArgumentList var3);

    protected boolean checkForUnsetParameters() {
        return true;
    }

    protected static FormalArgumentList createArgumentList(String[] argumentNames, SassListItem[] defaultValues, boolean hasVariableArguments) {
        ArrayList<Variable> nodes = new ArrayList<Variable>();
        for (int i = 0; i < argumentNames.length; ++i) {
            nodes.add(new Variable(argumentNames[i], defaultValues[i]));
        }
        return new FormalArgumentList(nodes, hasVariableArguments);
    }

    protected static FormalArgumentList createArgumentList(String[] argumentNames, SassListItem[] defaultValues) {
        return AbstractFunctionGenerator.createArgumentList(argumentNames, defaultValues, false);
    }

    protected static FormalArgumentList createArgumentList(String[] argumentNames, boolean hasVariableArguments) {
        SassListItem[] nullDefaults = new SassListItem[argumentNames.length];
        return AbstractFunctionGenerator.createArgumentList(argumentNames, nullDefaults, hasVariableArguments);
    }

    protected static SassListItem getParam(FormalArgumentList args, String name) {
        for (Variable var : args.getArguments()) {
            if (!var.getName().equals(name)) continue;
            return var.getExpr();
        }
        throw new ParseException("There is no argument " + name + " in the argument list: " + args.toString());
    }

    protected static SassListItem getParam(FormalArgumentList args, int index) {
        if (index < 0 || index >= args.size()) {
            throw new ParseException("Illegal index (" + index + ") for the argument list: " + args.toString());
        }
        return args.get(index).getExpr();
    }
}

