/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.expression;

import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;

public enum BinaryOperator {
    OR(106, 1){

        @Override
        public SassListItem eval(SassListItem leftValue, SassListItem rightValue) {
            if (1.isTrue(leftValue)) {
                return leftValue;
            }
            return rightValue;
        }
    }
    ,
    AND(105, 2){

        @Override
        public SassListItem eval(SassListItem leftValue, SassListItem rightValue) {
            if (2.isTrue(leftValue)) {
                return rightValue;
            }
            return leftValue;
        }
    }
    ,
    EQUALS(103, 3){

        @Override
        public SassListItem eval(SassListItem leftValue, SassListItem rightValue) {
            boolean value = leftValue.unquotedString().equals(rightValue.unquotedString());
            return BinaryOperator.createBooleanUnit(value);
        }
    }
    ,
    NOT_EQUAL(104, 3){

        @Override
        public SassListItem eval(SassListItem leftValue, SassListItem rightValue) {
            boolean value = !leftValue.unquotedString().equals(rightValue.unquotedString());
            return BinaryOperator.createBooleanUnit(value);
        }
    }
    ,
    LESS_THAN(7, 3){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return BinaryOperator.createBooleanUnit(BinaryOperator.getDoubleValue(leftValue) < BinaryOperator.getDoubleValue(rightValue));
        }
    }
    ,
    GREATER_THAN(8, 3){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return BinaryOperator.createBooleanUnit(BinaryOperator.getDoubleValue(leftValue) > BinaryOperator.getDoubleValue(rightValue));
        }
    }
    ,
    LESS_THAN_OR_EQUALS(9, 3){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return BinaryOperator.createBooleanUnit(BinaryOperator.getDoubleValue(leftValue) <= BinaryOperator.getDoubleValue(rightValue));
        }
    }
    ,
    GREATER_THAN_OR_EQUALS(10, 3){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return BinaryOperator.createBooleanUnit(BinaryOperator.getDoubleValue(leftValue) >= BinaryOperator.getDoubleValue(rightValue));
        }
    }
    ,
    ADD(1, 4){

        @Override
        public LexicalUnitImpl eval(SassListItem leftValue, SassListItem rightValue) {
            return this.add(leftValue, rightValue);
        }

        private LexicalUnitImpl add(SassListItem left, SassListItem right) {
            boolean quotedResult;
            if (left instanceof LexicalUnitImpl && right instanceof LexicalUnitImpl && !LexicalUnitImpl.checkLexicalUnitType(left, 36, 35) && !LexicalUnitImpl.checkLexicalUnitType(right, 36, 35)) {
                return ((LexicalUnitImpl)left).add((LexicalUnitImpl)right);
            }
            String leftValue = LexicalUnitImpl.checkLexicalUnitType(left, 36, 35) ? ((LexicalUnitImpl)left).getStringValue() : left.printState();
            String rightValue = LexicalUnitImpl.checkLexicalUnitType(right, 36, 35) ? ((LexicalUnitImpl)right).getStringValue() : right.printState();
            String stringValue = leftValue + rightValue;
            boolean bl = quotedResult = LexicalUnitImpl.checkLexicalUnitType(left, 36) || !LexicalUnitImpl.checkLexicalUnitType(left, 35) && LexicalUnitImpl.checkLexicalUnitType(right, 36);
            if (quotedResult) {
                return LexicalUnitImpl.createString(null, 0, 0, stringValue);
            }
            return LexicalUnitImpl.createIdent(stringValue);
        }
    }
    ,
    MINUS(2, 4){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return leftValue.minus(rightValue);
        }
    }
    ,
    MUL(3, 5){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return leftValue.multiply(rightValue);
        }
    }
    ,
    DIV(4, 5){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return leftValue.divide(rightValue);
        }
    }
    ,
    MOD(5, 5){

        @Override
        public LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
            return leftValue.modulo(rightValue);
        }
    };

    public final short type;
    public final int precedence;

    private BinaryOperator(short type, int precedence) {
        this.type = type;
        this.precedence = precedence;
    }

    public static boolean isTrue(SassListItem item) {
        if (item.getItemType() == 110) {
            return false;
        }
        return !"false".equals(item.printState());
    }

    private static double getDoubleValue(LexicalUnitImpl unit) {
        if (!unit.isNumber()) {
            throw new ParseException("The arguments of arithmetic expressions must be numbers:", unit);
        }
        return unit.getDoubleValue();
    }

    private static LexicalUnitImpl createBooleanUnit(boolean value) {
        return LexicalUnitImpl.createIdent(String.valueOf(value));
    }

    protected LexicalUnitImpl evalInternal(LexicalUnitImpl leftValue, LexicalUnitImpl rightValue) {
        return null;
    }

    public SassListItem eval(SassListItem leftOperand, SassListItem rightOperand) {
        return this.evalInternal(BinaryOperator.operand(leftOperand, true), BinaryOperator.operand(rightOperand, false));
    }

    private static LexicalUnitImpl operand(SassListItem item, boolean isLeftOperand) {
        if (!(item instanceof LexicalUnitImpl)) {
            throw new ParseException((isLeftOperand ? "Left" : "Right") + " operand of the operator is not a simple value", item);
        }
        LexicalUnitImpl operand = (LexicalUnitImpl)item;
        if (item.getItemType() == 100) {
            throw new ParseException("Variable was not resolved: " + operand, operand);
        }
        return operand;
    }
}

