/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.expression;

import com.inet.sass.ScssContext;
import com.inet.sass.expression.BinaryExpression;
import com.inet.sass.expression.BinaryOperator;
import com.inet.sass.expression.Parentheses;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import java.util.List;
import java.util.Stack;

public class ArithmeticExpressionEvaluator {
    private static void createNewOperand(BinaryOperator operator, Stack<Object> operands) {
        Object rightOperand = operands.pop();
        operands.push(new BinaryExpression(operands.pop(), operator, rightOperand));
    }

    private static boolean isShortCircuitEvaluation(BinaryOperator operator, Stack<Object> operands) {
        boolean value;
        switch (operator) {
            case OR: {
                value = true;
                break;
            }
            case AND: {
                value = false;
                break;
            }
            default: {
                return false;
            }
        }
        Object expr = operands.peek();
        SassListItem left = expr instanceof BinaryExpression ? ((BinaryExpression)expr).eval() : (SassListItem)expr;
        return value == BinaryOperator.isTrue(left);
    }

    private static Object createExpression(ScssContext context, List<SassListItem> terms) {
        SassListItem current = null;
        boolean afterOperand = false;
        Stack<Object> operands = new Stack<Object>();
        Stack<BinaryOperator> operators = new Stack<BinaryOperator>();
        int termCount = terms.size();
        for (int i = 0; i < termCount; ++i) {
            current = terms.get(i);
            if (current == LexicalUnitImpl.WHITESPACE) continue;
            if (afterOperand) {
                Object previous;
                BinaryOperator operator;
                afterOperand = false;
                switch (current.getItemType()) {
                    case 106: {
                        operator = BinaryOperator.OR;
                        break;
                    }
                    case 105: {
                        operator = BinaryOperator.AND;
                        break;
                    }
                    case 103: {
                        operator = BinaryOperator.EQUALS;
                        break;
                    }
                    case 104: {
                        operator = BinaryOperator.NOT_EQUAL;
                        break;
                    }
                    case 7: {
                        operator = BinaryOperator.LESS_THAN;
                        break;
                    }
                    case 8: {
                        operator = BinaryOperator.GREATER_THAN;
                        break;
                    }
                    case 9: {
                        operator = BinaryOperator.LESS_THAN_OR_EQUALS;
                        break;
                    }
                    case 10: {
                        operator = BinaryOperator.GREATER_THAN_OR_EQUALS;
                        break;
                    }
                    case 1: {
                        operator = BinaryOperator.ADD;
                        break;
                    }
                    case 2: {
                        operator = BinaryOperator.MINUS;
                        break;
                    }
                    case 3: {
                        operator = BinaryOperator.MUL;
                        break;
                    }
                    case 4: {
                        operator = BinaryOperator.DIV;
                        break;
                    }
                    case 5: {
                        operator = BinaryOperator.MOD;
                        break;
                    }
                    default: {
                        throw new ParseException("Illegal arithmetic expression: " + new SassList(SassList.Separator.SPACE, terms).printState(), current);
                    }
                }
                while (!operators.isEmpty() && (previous = operators.peek()) != Parentheses.LEFT && ((BinaryOperator)((Object)previous)).precedence >= operator.precedence) {
                    ArithmeticExpressionEvaluator.createNewOperand((BinaryOperator)((Object)operators.pop()), operands);
                }
                if (ArithmeticExpressionEvaluator.isShortCircuitEvaluation(operator, operands)) break;
                operators.push(operator);
                continue;
            }
            afterOperand = true;
            operands.push(current.evaluateFunctionsAndExpressions(context, true));
        }
        while (!operators.isEmpty()) {
            Object operator = operators.pop();
            if (operator == Parentheses.LEFT) {
                throw new ParseException("Unexpected \"(\" found", current);
            }
            ArithmeticExpressionEvaluator.createNewOperand((BinaryOperator)((Object)operator), operands);
        }
        Object expression = operands.pop();
        if (!operands.isEmpty()) {
            LexicalUnitImpl operand = (LexicalUnitImpl)operands.peek();
            throw new ParseException("Unexpected operand " + operand.toString() + " found", current);
        }
        return expression;
    }

    public static SassListItem evaluate(ScssContext context, List<SassListItem> terms) {
        Object result = ArithmeticExpressionEvaluator.createExpression(context, terms);
        if (result instanceof BinaryExpression) {
            return ((BinaryExpression)result).eval();
        }
        return (SassListItem)result;
    }
}

