/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass;

import com.inet.sass.InputSource;
import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSDocumentHandler;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.ScssParser;
import com.inet.sass.resolver.ScssStylesheetResolver;
import com.inet.sass.tree.Node;
import com.inet.sass.visitor.ExtendNodeHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ScssStylesheet
extends Node {
    private String uri;
    private String charset;
    private ScssStylesheetResolver resolver;
    private String prefix = "";
    private List<String> sourceUris = new ArrayList<String>();

    private ScssStylesheet() {
    }

    public static ScssStylesheet get(String identifier, SCSSErrorHandler errorHandler, ScssStylesheetResolver resolver) throws IOException {
        SCSSErrorHandler.set(errorHandler);
        return ScssStylesheet.load(identifier, null, resolver);
    }

    public ScssStylesheet importStylesheet(String identifier) throws IOException {
        return ScssStylesheet.load(identifier, this, this.resolver);
    }

    private static ScssStylesheet load(String identifier, ScssStylesheet parentStylesheet, ScssStylesheetResolver resolver) throws IOException {
        if (identifier == null) {
            return null;
        }
        ScssStylesheet stylesheet = new ScssStylesheet();
        stylesheet.resolver = resolver;
        SCSSDocumentHandler documentHandler = new SCSSDocumentHandler(stylesheet);
        InputSource source = stylesheet.resolveSource(identifier, parentStylesheet);
        if (source == null) {
            return null;
        }
        stylesheet.uri = source.getURI();
        if (parentStylesheet != null) {
            stylesheet.setCharset(parentStylesheet.getCharset());
        }
        ScssParser parser = new ScssParser();
        parser.parseStyleSheet(documentHandler, source);
        stylesheet.sourceUris.add(source.getURI());
        return stylesheet;
    }

    public InputSource resolveSource(String identifier, ScssStylesheet parentStylesheet) {
        if (this.resolver != null) {
            return this.resolver.resolve(parentStylesheet, identifier);
        }
        return null;
    }

    public List<String> getSourceUris() {
        return this.sourceUris;
    }

    public void addSourceUris(Collection<String> uris) {
        this.sourceUris.addAll(uris);
    }

    public void compile() throws Exception {
        this.compile(ScssContext.UrlMode.MIXED);
    }

    public void compile(ScssContext.UrlMode urlMode) throws Exception {
        ScssContext context = new ScssContext(urlMode, this);
        this.traverse(context);
        ExtendNodeHandler.modifyTree(context, this);
    }

    @Override
    public String printState() {
        return this.buildString(PRINT_STRATEGY);
    }

    public String toString() {
        return "Stylesheet node [" + this.buildString(TO_STRING_STRATEGY) + "]";
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        this.traverseChildren(context);
        return Collections.singleton(this);
    }

    public String getDirectory() {
        int idx = this.uri.lastIndexOf(47);
        return idx < 0 ? "" : this.uri.substring(0, idx);
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public static final void warning(String msg) {
        SCSSErrorHandler.get().warning(msg);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private String buildString(Node.BuildStringStrategy strategy) {
        List<Node> children;
        StringBuilder string = new StringBuilder("");
        String delimeter = "\n\n";
        if (this.charset != null && !"ASCII".equals(this.charset)) {
            string.append("@charset \"").append(this.charset).append("\";").append(delimeter);
        }
        if ((children = this.getChildren()).size() > 0) {
            string.append(strategy.build(children.get(0)));
        }
        if (children.size() > 1) {
            for (int i = 1; i < children.size(); ++i) {
                String childString = strategy.build(children.get(i));
                if (childString == null) continue;
                string.append(delimeter).append(childString);
            }
        }
        String output = string.toString();
        return output;
    }

    @Override
    public Node copy() {
        throw new UnsupportedOperationException("ScssStylesheet cannot be copied");
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.printState());
    }
}

