/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass;

import com.inet.sass.Scope;
import com.inet.sass.ScssStylesheet;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.BlockNode;
import com.inet.sass.tree.FunctionDefNode;
import com.inet.sass.tree.MixinDefNode;
import com.inet.sass.visitor.Extension;
import java.util.LinkedHashSet;
import java.util.Set;

public class ScssContext {
    private UrlMode urlMode;
    private Scope scope = new Scope();
    private ScssStylesheet stylesheet;
    private BlockNode parentBlock;
    private Set<Extension> extendsSet = new LinkedHashSet<Extension>();

    public ScssContext(UrlMode urlMode, ScssStylesheet stylesheet) {
        this.urlMode = urlMode;
        this.stylesheet = stylesheet;
    }

    public void defineFunction(FunctionDefNode function) {
        this.scope.defineFunction(function);
    }

    public void defineMixin(MixinDefNode mixin) {
        this.scope.defineMixin(mixin);
    }

    public Scope openVariableScope(Scope parent) {
        Scope previousScope = this.scope;
        this.scope = new Scope(parent);
        return previousScope;
    }

    public void closeVariableScope(Scope newScope) {
        this.scope = newScope;
    }

    public Scope getCurrentScope() {
        return this.scope;
    }

    public void openVariableScope() {
        this.scope = new Scope(this.scope);
    }

    public void closeVariableScope() {
        this.scope = this.scope.getParent();
    }

    public void setVariable(Variable node) {
        this.scope.setVariable(node);
    }

    public void addVariable(Variable node) {
        this.scope.addVariable(node);
    }

    public Variable getVariable(String string) {
        return this.scope.getVariable(string);
    }

    public MixinDefNode getMixinDefinition(String name) {
        return this.scope.getMixinDefinition(name);
    }

    public FunctionDefNode getFunctionDefinition(String name) {
        return this.scope.getFunctionDefinition(name);
    }

    public void addExtension(Extension extension) {
        this.extendsSet.add(extension);
    }

    public Iterable<Extension> getExtensions() {
        return this.extendsSet;
    }

    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    public void setUrlMode(UrlMode urlMode) {
        this.urlMode = urlMode;
    }

    public ScssStylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(ScssStylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public BlockNode getParentBlock() {
        return this.parentBlock;
    }

    public void setParentBlock(BlockNode node) {
        this.parentBlock = node;
    }

    public static enum UrlMode {
        ABSOLUTE,
        MIXED,
        RELATIVE;

    }
}

