/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass;

import com.inet.sass.Definition;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.FunctionDefNode;
import com.inet.sass.tree.MixinDefNode;
import java.util.HashMap;

public class Scope {
    private static final Definition MISSING = new Variable(null, null);
    private Scope parent;
    private final DefinitionScope<Variable> variables;
    private final DefinitionScope<FunctionDefNode> functions;
    private final DefinitionScope<MixinDefNode> mixins;

    public Scope() {
        this.variables = new DefinitionScope(null);
        this.functions = new DefinitionScope(null);
        this.mixins = new DefinitionScope(null);
    }

    public Scope(Scope parent) {
        this.parent = parent;
        this.variables = new DefinitionScope<Variable>(parent.variables);
        this.functions = new DefinitionScope<FunctionDefNode>(parent.functions);
        this.mixins = new DefinitionScope<MixinDefNode>(parent.mixins);
    }

    public Scope getParent() {
        return this.parent;
    }

    public void setVariable(Variable node) {
        this.variables.set(node);
    }

    public void addVariable(Variable node) {
        this.variables.add(node);
    }

    public Variable getVariable(String name) {
        return this.variables.get(name);
    }

    public void defineFunction(FunctionDefNode function) {
        this.functions.add(function);
    }

    public void defineMixin(MixinDefNode mixin) {
        this.mixins.add(mixin);
    }

    public FunctionDefNode getFunctionDefinition(String name) {
        return this.functions.get(name);
    }

    public MixinDefNode getMixinDefinition(String name) {
        return this.mixins.get(name);
    }

    public String toString() {
        return "Variables: " + this.variables.toString() + "\nFunctions: " + this.functions.toString() + "\nMixins: " + this.mixins.toString();
    }

    private static class DefinitionScope<T extends Definition> {
        private DefinitionScope<T> parent;
        private HashMap<String, T> definitions;

        public DefinitionScope(DefinitionScope<T> parent) {
            this.parent = parent;
        }

        public void set(T node) {
            if (this.parent == null || !super.setIfPresent(node)) {
                this.add(node);
            }
        }

        public void add(T node) {
            HashMap<String, Object> definitions = this.definitions;
            if (definitions == null) {
                this.definitions = new HashMap();
                definitions = this.definitions;
            }
            definitions.put(node.getName(), node);
        }

        private boolean setIfPresent(T node) {
            if (this.parent != null && super.setIfPresent(node)) {
                return true;
            }
            HashMap<String, T> definitions = this.definitions;
            if (definitions != null) {
                return definitions.replace(node.getName(), node) != null;
            }
            return false;
        }

        public T get(String name) {
            Definition value;
            HashMap<String, T> definitions = this.definitions;
            if (definitions != null && (value = definitions.getOrDefault(name, MISSING)) != MISSING) {
                return (T)value;
            }
            DefinitionScope<T> parent = this.parent;
            if (parent != null) {
                return parent.get(name);
            }
            return null;
        }

        public String toString() {
            if (this.definitions != null) {
                return this.definitions.keySet().toString() + ", parent = " + this.parent;
            }
            return "{}, parent = " + this.parent;
        }
    }
}

