/*
 * Copyright 2023 i-net software
 * Copyright 2000-2014 Vaadin Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/* Generated By:JavaCC: Do not edit this line. ParseException.java Version 0.7pre6 */
package com.inet.sass.parser;

import com.inet.sass.tree.Node;
import com.inet.sass.tree.SourceLocation;

/**
 * This exception is thrown when parse errors are encountered. You can
 * explicitly create objects of this exception type by calling the method
 * generateParseException in the generated parser.
 * 
 * You can modify this class to customize your error reporting mechanisms so
 * long as you retain the public fields.
 */
public class ParseException extends RuntimeException {

    /**
     * The following constructors are for use by you for whatever purpose you
     * can think of. Constructing the exception in this manner makes the
     * exception behave in the normal way - i.e., as documented in the class
     * "Throwable". The fields "errorToken", "expectedTokenSequences", and
     * "tokenImage" do not contain relevant information. The JavaCC generated
     * code does not use these constructors.
     */

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, SourceLocation unit) {
        this(message);
        currentUnit = unit;
    }

    public ParseException(String message, ActualArgumentList args) {
        this(message);
        if (args.size() > 0) {
            currentUnit = args.get(0);
        }
    }

    public ParseException(String message, String uri, int line, int column) {
        super(message + " in line " + line + ", column " + column + getLocation( uri ) );
    }

    /**
     * When not using a special constructor, if the current unit is not null, it
     * is used to determine the location of the exception in the parsed file.
     */
    private SourceLocation currentUnit;

    /**
     * This method has the standard behavior when this object has been created
     * using the standard constructors. Otherwise, it uses "currentToken" and
     * "expectedTokenSequences" to generate a parse error message and returns
     * it. If this object has been created due to a parse error, and you do not
     * catch it (it gets thrown from the parser), then this method is called
     * during the printing of the final stack trace, and hence the correct error
     * message gets displayed.
     */
    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (currentUnit != null) {
            message = message + " at line " + currentUnit.getLineNumber() + ", column " + currentUnit.getColumnNumber() + getLocation();
        }
        return message;
    }

    private String getLocation() {
        if( currentUnit == null ) {
            return "";
        }
        String fileName = currentUnit.getUri();
        if( fileName == null && currentUnit instanceof Node ) {
            Node node = (Node)currentUnit;
            while( fileName == null && node != null ) {
                node = node.getParentNode();
                fileName = node.getUri();
            }
        }
        return getLocation( fileName );
    }

    private static String getLocation( String fileName ) {
        if( fileName != null ) {
            fileName = fileName.substring( fileName.lastIndexOf( '/' ) + 1 );
            return ", in file " + fileName;
        } else {
            return "";
        }
    }
}
