/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.forms;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;

public class ShapeSerializer {
    public static void writeShape(@Nullable Shape shape, DataOutput out) throws IOException {
        if (shape == null) {
            out.writeInt(-1);
            return;
        }
        PathIterator path = shape.getPathIterator(null);
        int windingRule = path.getWindingRule();
        out.writeInt(windingRule);
        float[] coords = new float[6];
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            out.writeInt(type);
            switch (type) {
                case 0: 
                case 1: {
                    out.writeFloat(coords[0]);
                    out.writeFloat(coords[1]);
                    break;
                }
                case 2: {
                    out.writeFloat(coords[0]);
                    out.writeFloat(coords[1]);
                    out.writeFloat(coords[2]);
                    out.writeFloat(coords[3]);
                    break;
                }
                case 3: {
                    out.writeFloat(coords[0]);
                    out.writeFloat(coords[1]);
                    out.writeFloat(coords[2]);
                    out.writeFloat(coords[3]);
                    out.writeFloat(coords[4]);
                    out.writeFloat(coords[5]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Shape Segment type:" + type);
                }
            }
            path.next();
        }
        out.writeInt(-1);
    }

    @Nullable
    public static Shape readShape(DataInput stream) throws IOException {
        int windingRule = stream.readInt();
        if (windingRule == -1) {
            return null;
        }
        GeneralPath localGeneralPath = new GeneralPath(windingRule);
        while (true) {
            int i = stream.readInt();
            switch (i) {
                case -1: {
                    return localGeneralPath;
                }
                case 0: {
                    localGeneralPath.moveTo(stream.readFloat(), stream.readFloat());
                    break;
                }
                case 1: {
                    localGeneralPath.lineTo(stream.readFloat(), stream.readFloat());
                    break;
                }
                case 2: {
                    localGeneralPath.quadTo(stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat());
                    break;
                }
                case 3: {
                    localGeneralPath.curveTo(stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat());
                    break;
                }
                case 4: {
                    localGeneralPath.closePath();
                }
            }
        }
    }
}

