/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.util.Arrays;

@InternalApi
public class PaintComparator {
    private int rgbTolerance;
    private double hsvTolerance;

    public PaintComparator(double hsvTolerance) {
        this.hsvTolerance = hsvTolerance;
        this.rgbTolerance = (int)Math.round(hsvTolerance * 255.0);
    }

    public boolean canCompare(Paint p) {
        if (p == null) {
            return true;
        }
        if (p instanceof Color || p instanceof RadialGradientPaint || p instanceof LinearGradientPaint) {
            return true;
        }
        try {
            return p.getClass().getDeclaredMethod("equals", Object.class) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEqual(Paint p1, Paint p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1 instanceof RadialGradientPaint && p2 instanceof RadialGradientPaint) {
            RadialGradientPaint rgp1 = (RadialGradientPaint)p1;
            RadialGradientPaint rgp2 = (RadialGradientPaint)p2;
            if (!this.compareColorArrays(rgp1.getColors(), rgp2.getColors())) {
                return false;
            }
            if (rgp1.getCycleMethod() != rgp2.getCycleMethod()) {
                return false;
            }
            if (!rgp1.getFocusPoint().equals(rgp2.getFocusPoint())) {
                return false;
            }
            if (!Arrays.equals(rgp1.getFractions(), rgp2.getFractions())) {
                return false;
            }
            return !(rgp1.getRadius() - rgp2.getRadius() > 1.0f);
        }
        if (p1 instanceof LinearGradientPaint && p2 instanceof LinearGradientPaint) {
            LinearGradientPaint lgp1 = (LinearGradientPaint)p1;
            LinearGradientPaint lgp2 = (LinearGradientPaint)p2;
            if (!this.compareColorArrays(lgp1.getColors(), lgp2.getColors())) {
                return false;
            }
            if (lgp1.getCycleMethod() != lgp2.getCycleMethod()) {
                return false;
            }
            if (!Arrays.equals(lgp1.getFractions(), lgp2.getFractions())) {
                return false;
            }
            if (!lgp1.getStartPoint().equals(lgp2.getStartPoint())) {
                return false;
            }
            return lgp1.getEndPoint().equals(lgp2.getEndPoint());
        }
        if (p1 instanceof Color && p2 instanceof Color) {
            return this.isEqualColor((Color)p1, (Color)p2);
        }
        return p1.equals(p2) || p2.equals(p1);
    }

    private boolean compareColorArrays(Color[] a1, Color[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.isEqualColor(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualColor(Color c1, Color c2) {
        if (Math.abs(c1.getRed() - c2.getRed()) <= this.rgbTolerance && Math.abs(c1.getGreen() - c2.getGreen()) <= this.rgbTolerance && Math.abs(c1.getBlue() - c2.getBlue()) <= this.rgbTolerance && Math.abs(c1.getAlpha() - c2.getAlpha()) <= this.rgbTolerance) {
            return true;
        }
        float[] hsb1 = Color.RGBtoHSB(c1.getRed(), c1.getGreen(), c1.getBlue(), new float[3]);
        float[] hsb2 = Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), new float[3]);
        return PaintComparator.assertEqualsColor(hsb1, hsb2, this.hsvTolerance);
    }

    private static boolean assertEqualsColor(float[] hsbExpected, float[] hsbCurrent, double delta) {
        if (!PaintComparator.assertEquals(hsbExpected[2], hsbCurrent[2], delta)) {
            return false;
        }
        if (!(hsbExpected[2] + hsbCurrent[2] > 0.0f)) {
            return true;
        }
        if (!PaintComparator.assertEquals(hsbExpected[1], hsbCurrent[1], delta /= (double)((hsbExpected[2] + hsbCurrent[2]) / 2.0f))) {
            return false;
        }
        if (!(hsbExpected[1] + hsbCurrent[1] > 0.0f)) {
            return true;
        }
        if (!PaintComparator.assertEquals(hsbExpected[0], hsbCurrent[0], delta /= (double)((hsbExpected[1] + hsbCurrent[1]) / 2.0f))) {
            float newCurrent;
            float f = newCurrent = hsbCurrent[0] < hsbExpected[0] ? hsbCurrent[0] + 1.0f : hsbCurrent[0] - 1.0f;
            if (!PaintComparator.assertEquals(hsbExpected[0], newCurrent, delta)) {
                return false;
            }
        }
        return true;
    }

    private static boolean assertEquals(double expectedVal, double actualValue, double delta) {
        return !(Math.abs(actualValue - expectedVal) > delta);
    }
}

