/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.generator.model.DifferencePages;
import com.inet.pdfc.generator.model.IDiffGroupBounds;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.PagedElement;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
@PublicApi
public abstract class DiffGroup
implements Serializable {
    public abstract List<PagedElement> getRemovedElements();

    public abstract List<PagedElement> getAddedElements();

    public abstract Rectangle getBounds(boolean var1);

    public abstract int getDifferencesCount();

    public abstract IDiffGroupBounds getBoundingElements();

    public abstract GroupType getType();

    public String toString() {
        return this.getType().name() + ": " + this.getRemovedElements() + " -> " + this.getAddedElements();
    }

    public abstract List<Modification> getModifications();

    public DifferencePages getDifferencePages(boolean first) {
        List<Modification> modifications = this.getModifications();
        if (modifications.size() > 0) {
            int startPage = -1;
            int endPage = -1;
            for (Modification modification : modifications) {
                DifferencePages pageNumber = modification.getDifferencePages(first);
                if (pageNumber == null) continue;
                if (startPage == -1) {
                    startPage = pageNumber.getStartPage();
                    endPage = pageNumber.getEndPage();
                }
                if (pageNumber.getStartPage() < startPage) {
                    startPage = pageNumber.getStartPage();
                }
                if (pageNumber.getEndPage() <= endPage) continue;
                endPage = pageNumber.getEndPage();
            }
            if (startPage == -1) {
                PagedElement after;
                IDiffGroupBounds bounds = this.getBoundingElements();
                PagedElement before = first ? bounds.getBeforeFirst() : bounds.getBeforeSecond();
                PagedElement pagedElement = after = first ? bounds.getAfterFirst() : bounds.getAfterSecond();
                if (before != null) {
                    if (after != null) {
                        startPage = before.getPageIndex() + 1;
                        endPage = after.getPageIndex() + 1;
                    } else {
                        startPage = before.getPageIndex() + 1;
                        endPage = before.getPageIndex() + 1;
                    }
                } else if (after != null) {
                    startPage = after.getPageIndex() + 1;
                    endPage = after.getPageIndex() + 1;
                } else {
                    return null;
                }
            }
            if (startPage == -1) {
                return null;
            }
            return new DifferencePages(startPage, endPage);
        }
        return null;
    }

    @PublicApi
    public static enum GroupType implements ColorSetting
    {
        AddedOrRemoved(true),
        Replaced(true),
        Modified(true),
        ValidationError(true),
        MetadataChanged(true),
        Sync(false);

        private static final GroupType[] VISIBLE;
        private boolean doPaint;

        private GroupType(boolean doPaint) {
            this.doPaint = doPaint;
        }

        public boolean isTypePainted() {
            return this.doPaint;
        }

        public static GroupType[] valuesVisible() {
            return VISIBLE;
        }

        public String getLocalizedName() {
            return Msg.getMsg("Settings." + this.getTranslationKey());
        }

        @Override
        public String getTyp() {
            return "GroupType";
        }

        static {
            VISIBLE = Arrays.asList(GroupType.values()).stream().filter(e -> e.doPaint).collect(Collectors.toList()).toArray(new GroupType[0]);
        }
    }
}

