/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.message.Chunk;

@JsonData
@InternalApi
public class PageReadDone
implements Chunk {
    private int startL = -1;
    private int startR = -1;
    private int endL = -1;
    private int endR = -1;

    public PageReadDone(int pageNr, boolean first) {
        if (first) {
            this.startL = pageNr;
            this.endL = pageNr;
        } else {
            this.startR = pageNr;
            this.endR = pageNr;
        }
    }

    private PageReadDone() {
    }

    public void add(PageReadDone toAdd) {
        if (toAdd.startL >= 0) {
            this.startL = Math.min(this.startL, toAdd.startL);
        }
        if (toAdd.startR >= 0) {
            this.startR = Math.min(this.startR, toAdd.startR);
        }
        if (toAdd.endL >= 0) {
            this.endL = Math.min(this.endL, toAdd.endL);
        }
        if (toAdd.endR >= 0) {
            this.endR = Math.min(this.endR, toAdd.endR);
        }
    }

    public int getStart(boolean first) {
        return first ? this.startL : this.startR;
    }

    public int getEnd(boolean first) {
        return first ? this.endL : this.endR;
    }

    @Override
    public Chunk.ChunkType getType() {
        return Chunk.ChunkType.pageAnalyzed;
    }
}

