/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PublicApi
public class ValidValueProvider {
    private List<ValidValue> values;

    public ValidValueProvider(@Nonnull List<ValidValue> values) {
        this.values = values;
    }

    public ValidValueProvider(Object[] values) {
        this.values = Arrays.asList(values).stream().map(t -> new DefaultValidValue(t.toString())).collect(Collectors.toList());
    }

    public List<ValidValue> getValidValues() {
        return this.values;
    }

    private static class DefaultValidValue
    implements ValidValue {
        private String key;

        private DefaultValidValue(String key) {
            this.key = key;
        }

        @Override
        public String getProfileValue() {
            return this.key;
        }

        @Override
        public String getDisplayString() {
            return this.key;
        }

        public String toString() {
            return this.key;
        }
    }

    @PublicApi
    public static interface ValidValue {
        public String getProfileValue();

        public String getDisplayString();
    }
}

