/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class EncodedWriter
extends Writer {
    private final Writer output;
    private int xor = 71;
    private StringBuilder oldWriter;

    public EncodedWriter(Writer output) {
        this.output = output;
    }

    public EncodedWriter(OutputStream output) {
        this(new UTF8StreamWriter(output));
    }

    public EncodedWriter(OutputStream output, boolean oldEncode) {
        this(output);
        if (oldEncode) {
            this.oldWriter = new StringBuilder();
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.oldWriter != null) {
            this.oldWriter.append((char)ch);
        } else {
            this.output.write(ch ^ this.xor);
            this.xor = ch & 0xFF;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.oldWriter != null) {
            this.oldWriter.append(cbuf, off, len);
        } else {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off + i]);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.oldWriter != null) {
            for (int i = this.oldWriter.length() - 1; i >= 0; --i) {
                this.output.write((char)(this.oldWriter.charAt(i) + '\u0001'));
            }
        }
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
    }
}

