/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client.impl;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.MinifiedElement;
import com.inet.pdfc.generator.model.MutableDiffGroup;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.pdfc.textselection.TextInfoImpl;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

@InternalApi
public class RPCTypeResolver
extends JsonTypeResolver {
    private Type getMinifiedTypeFor(Type type) {
        if (type instanceof WildcardType) {
            Type[] upper;
            WildcardType wildcard = (WildcardType)type;
            Type[] lower = wildcard.getLowerBounds();
            if (lower.length == 1) {
                type = lower[0];
            }
            if ((upper = wildcard.getUpperBounds()).length == 1) {
                type = upper[0];
            }
        }
        if (type == DiffGroup.class || type == MutableDiffGroup.class) {
            return CompareDiffGroup.class;
        }
        if (type == Rectangle2D.class) {
            return Rectangle2D.Float.class;
        }
        if (type == TextInfo.class) {
            return TextInfoImpl.class;
        }
        if (type == IProfile.class) {
            return DefaultProfile.class;
        }
        if (type == PdfSource.class) {
            return BasicPdfSource.class;
        }
        if (type == PagedElement.class) {
            return MinifiedElement.class;
        }
        if (type == AttributeDifference.class) {
            return BasicAttributeDifference.class;
        }
        if (type == HighlightData.class) {
            return BasicHighlightDataImpl.class;
        }
        return type;
    }

    @Override
    protected Type getGenericType(Object obj, Field field) {
        return this.getParameterizedType(field.getGenericType());
    }

    private Type getParameterizedType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return this.getMinifiedTypeFor(type);
        }
        ParameterizedType pType = (ParameterizedType)type;
        Type[] params = pType.getActualTypeArguments();
        Type[] jsonTypeParams = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            jsonTypeParams[i] = this.getParameterizedType(params[i]);
        }
        return new JsonParameterizedType(this.getMinifiedTypeFor(pType.getRawType()), jsonTypeParams);
    }

    @JsonData
    private static class BasicPdfSource
    extends PdfSource {
        private String name;

        private BasicPdfSource() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof BasicPdfSource && ((BasicPdfSource)other).getName().equals(this.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class BasicAttributeDifference
    extends AttributeDifference<String> {
        public BasicAttributeDifference() {
            super(AttributeDifference.TYPE.MINIFIED, null, null, "");
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof AttributeDifference)) {
                return false;
            }
            AttributeDifference ad = (AttributeDifference)other;
            return this.getInstanceType() == ad.getInstanceType() && this.getNewValueDescriptor().equals(ad.getNewValueDescriptor()) && this.getOldValueDescriptor().equals(ad.getOldValueDescriptor());
        }
    }
}

