/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.text;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.PaintComparator;
import com.inet.pdfc.model.TextElement;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@InternalApi
public class TextStyle
implements Serializable {
    private double slope;
    private double rotation;
    private float fontSize;
    private FontInfo font;
    private transient Paint strokePaint;
    private transient Paint fillPaint;
    private transient Paint backgroundPaint = new Color(0, 0, 0, 0);
    private int styleOverride;
    private double textHeight;
    private double wsWidth;
    private double wsWidthScaled;
    private boolean hasUnderline;
    private boolean hasStrikethrough;
    private Boolean isSuperscript_sub = null;

    public TextStyle(double rotation, float fontSize, FontInfo font) {
        this.rotation = rotation;
        this.fontSize = fontSize;
        this.font = font;
        this.strokePaint = null;
        this.fillPaint = Color.BLACK;
        this.styleOverride = 0;
        this.textHeight = fontSize * 4.0f / 3.0f;
        this.wsWidthScaled = this.wsWidth = font != null ? (double)(font.getMetrics((int)(fontSize * 100.0f)).charWidth(' ') / 100) : (double)(fontSize / 3.0f);
    }

    public TextStyle(TextElement pdfText, double wsWidthFactor) {
        AffineTransform at = new AffineTransform(pdfText.getTransformMatrix());
        this.textHeight = pdfText.getStyle().getTextHeight() * Math.abs(at.getScaleY() + at.getShearY());
        this.font = pdfText.getStyle().getFont();
        this.fontSize = pdfText.getStyle().getFontSize();
        this.strokePaint = pdfText.getStyle().getStrokePaint();
        this.fillPaint = pdfText.getStyle().getFillPaint();
        this.styleOverride = pdfText.getStyle().getStyleOverride();
        this.slope = pdfText.getStyle().getSlope();
        this.rotation = pdfText.getStyle().getRotation();
        this.wsWidth = pdfText.getStyle().getWsWidth() * wsWidthFactor;
        this.wsWidthScaled = pdfText.getStyle().getWsWidthScaled() * wsWidthFactor;
        this.isSuperscript_sub = pdfText.getStyle().getSuperscript_sub();
        this.hasUnderline = pdfText.getStyle().hasUnderline();
        this.hasStrikethrough = pdfText.getStyle().hasStrikethrough();
    }

    public TextStyle(FontInfo fontInfo, float fontSize, Paint fillPaint, Paint strokePaint) {
        this.font = fontInfo;
        this.fontSize = fontSize;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public boolean hasUnderline() {
        return this.hasUnderline;
    }

    public boolean hasStrikethrough() {
        return this.hasStrikethrough;
    }

    public Boolean getSuperscript_sub() {
        return this.isSuperscript_sub;
    }

    public void setSuperscript_sub(Boolean superscript_sub) {
        this.isSuperscript_sub = superscript_sub;
    }

    public void setHasUnderline(boolean hasUnderline) {
        this.hasUnderline = hasUnderline;
    }

    public void setHasStrikethrough(boolean hasStrikethrough) {
        this.hasStrikethrough = hasStrikethrough;
    }

    public double getWsWidth() {
        return this.wsWidth;
    }

    public void setWsWidth(double wsWidth) {
        this.wsWidth = wsWidth;
    }

    public double getWsWidthScaled() {
        return this.wsWidthScaled;
    }

    public void setWsWidthScaled(double wsWidthScaled) {
        this.wsWidthScaled = wsWidthScaled;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public FontInfo getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public int getStyleOverride() {
        return this.styleOverride;
    }

    public void setStyleOverride(int styleOverride) {
        this.styleOverride = styleOverride;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(double textHeight) {
        this.textHeight = textHeight;
    }

    public double getMinimumWhiteSpaceSize() {
        return this.wsWidth;
    }

    public double getMinimumScaledWhiteSpaceSize() {
        return this.wsWidthScaled;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextStyle)) {
            return false;
        }
        TextStyle other = (TextStyle)obj;
        if (Double.compare(this.fontSize, other.fontSize) != 0) {
            return false;
        }
        if (Double.compare(this.textHeight, other.textHeight) != 0) {
            return false;
        }
        if (Double.compare(this.slope, other.slope) != 0) {
            return false;
        }
        if (Double.compare(this.wsWidth, other.wsWidth) != 0) {
            return false;
        }
        if (this.styleOverride != other.styleOverride) {
            return false;
        }
        if (this.hasStrikethrough != other.hasStrikethrough) {
            return false;
        }
        if (this.hasUnderline != other.hasUnderline) {
            return false;
        }
        if (this.isSuperscript_sub != null && other.isSuperscript_sub != null && Boolean.compare(this.isSuperscript_sub, other.isSuperscript_sub) != 0) {
            return false;
        }
        if (this.isSuperscript_sub != null && other.isSuperscript_sub == null || this.isSuperscript_sub == null && other.isSuperscript_sub != null) {
            return false;
        }
        if (!this.font.getFontName().equals(other.font.getFontName()) || !this.font.getFamilyName().equals(other.font.getFamilyName())) {
            return false;
        }
        PaintComparator comparator = new PaintComparator(0.01);
        if (!comparator.isEqual(this.fillPaint, other.fillPaint)) {
            return false;
        }
        return comparator.isEqual(this.strokePaint, other.strokePaint);
    }

    public String toString() {
        return "TextStyle{slope=" + this.slope + ", rotation=" + this.rotation + ", fontSize=" + this.fontSize + ", font=" + this.font + ", strokePaint=" + this.strokePaint + ", fillPaint=" + this.fillPaint + ", styleOverride=" + this.styleOverride + ", textHeight=" + this.textHeight + ", wsWidth=" + this.wsWidth + ", wsWidthScaled=" + this.wsWidthScaled + ", hasUnderline=" + this.hasUnderline + ", hasStrikethrough=" + this.hasStrikethrough + ", isSuperscript_sub=" + this.isSuperscript_sub + '}';
    }

    public boolean isSimilar(TextStyle other) {
        if ((double)Math.abs(this.fontSize - other.fontSize) > 0.05) {
            return false;
        }
        return this.font.getFontName().equals(other.font.getFontName()) && this.font.getFamilyName().equals(other.font.getFamilyName());
    }

    public int hashCode() {
        int hash = this.font.hashCode() * Double.hashCode(this.fontSize) * Double.hashCode(this.slope);
        if (this.fillPaint != null) {
            hash *= this.fillPaint.hashCode();
        }
        if (this.strokePaint != null) {
            hash *= this.strokePaint.hashCode();
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(this.font instanceof Serializable)) {
            this.font = new SerializableFontInfo(this.font);
        }
        out.defaultWriteObject();
        if (this.strokePaint == null || this.strokePaint instanceof Serializable) {
            out.writeObject(this.strokePaint);
        } else {
            out.writeObject(null);
        }
        if (this.fillPaint == null || this.fillPaint instanceof Serializable) {
            out.writeObject(this.fillPaint);
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.strokePaint = (Paint)in.readObject();
        this.fillPaint = (Paint)in.readObject();
    }

    private static class SerializableFontInfo
    implements FontInfo,
    Serializable {
        private float ascend;
        private String familyName;
        private String fontName;
        private FontMetrics metrics;
        private int style;
        private double wsWidth;

        public SerializableFontInfo(FontInfo source) {
            this.ascend = source.getAscend(100);
            this.familyName = source.getFamilyName();
            this.fontName = source.getFontName();
            this.metrics = source.getMetrics(100);
            this.style = source.getStyle();
            this.wsWidth = source.getWSWidth(100.0f);
        }

        @Override
        public double getWSWidth(float fontSize) {
            return this.wsWidth * (double)fontSize / 100.0;
        }

        @Override
        public FontMetrics getMetrics(int size) {
            return Toolkit.getDefaultToolkit().getFontMetrics(this.metrics.getFont().deriveFont(size));
        }

        @Override
        public float getAscend(int size) {
            return this.ascend * (float)size / 100.0f;
        }

        @Override
        public String getFamilyName() {
            return this.familyName;
        }

        @Override
        public int getStyle() {
            return this.style;
        }

        @Override
        public String getFontName() {
            return this.fontName;
        }
    }
}

