/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client.impl;

import com.inet.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;

public class ConsoleLogger
implements Logger {
    private int level = 1;
    private static final String[] LEVELS = new String[]{"STATUS", "FATAL", "ERROR", "WARNING", "INFO", "DEBUG", "TRACE"};

    @Override
    public void status(Object message) {
        this.print(-1, message);
    }

    @Override
    public void debug(Object message) {
        this.print(4, message);
    }

    @Override
    public void error(Object message) {
        this.print(1, message);
    }

    @Override
    public void fatal(Object message) {
        this.print(0, message);
    }

    @Override
    public void info(Object message) {
        this.print(3, message);
    }

    @Override
    public void warn(Object message) {
        this.print(2, message);
    }

    @Override
    public void setLogLevel(int level) {
        this.level = level;
    }

    @Override
    public int getLogLevel() {
        return this.level;
    }

    @Override
    public boolean isDebug() {
        return this.level <= 4;
    }

    @Override
    public boolean isInfo() {
        return this.level <= 3;
    }

    @Override
    public boolean isWarning() {
        return this.level <= 2;
    }

    @Override
    public boolean isError() {
        return this.level <= 1;
    }

    private void print(int level, Object msg) {
        if (this.level >= level) {
            ++level;
            if (msg instanceof Throwable) {
                StringWriter w = new StringWriter();
                ((Throwable)msg).printStackTrace(new PrintWriter(w));
                System.out.println("[" + Calendar.getInstance().getTime() + "] " + LEVELS[level] + ": " + w.getBuffer().toString());
            } else {
                System.out.println("[" + Calendar.getInstance().getTime() + "] " + LEVELS[level] + ": " + msg);
            }
        }
    }
}

