/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.State;

@JsonData
@InternalApi
public final class ProgressState
implements Chunk {
    private State id = State.IDLE;
    private float value;

    private ProgressState() {
    }

    public ProgressState(State id) {
        this(id, 0.0f);
    }

    public ProgressState(State id, float value) {
        value = Math.max(value, 0.0f);
        this.id = id;
        this.value = value;
    }

    public State getId() {
        return this.id;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float calculateProgressValue() {
        switch (this.id) {
            case IDLE: {
                return 0.0f;
            }
            case START: {
                return 3.0f;
            }
            case COMPARING: {
                return this.value > 100.0f ? 100.0f : 3.0f + 97.0f * this.value / 100.0f;
            }
            case FINISHED: {
                return 100.0f;
            }
        }
        return this.value > 100.0f ? 100.0f : 100.0f * this.value / 100.0f;
    }

    @Override
    public Chunk.ChunkType getType() {
        return Chunk.ChunkType.progress;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProgressState)) {
            return false;
        }
        ProgressState other = (ProgressState)obj;
        return other.id == this.id && other.value == this.value;
    }
}

