/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.JsonException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class BonWriter {
    static final int TOKEN_NULL = 33;
    static final int TOKEN_FALSE = 34;
    static final int TOKEN_TRUE = 35;
    static final int TOKEN_POS_INT = 36;
    static final int TOKEN_NEG_INT = 37;
    static final int TOKEN_FLOAT = 38;
    static final byte TOKEN_DOUBLE = 39;
    static final int TOKEN_START_ARRAY = 40;
    static final int TOKEN_START_OBJECT = 41;
    static final int TOKEN_START_MAP = 42;
    static final int TOKEN_END = 43;
    static final int TOKEN_STRING = 44;
    static final int TOKEN_BYTES = 45;
    static final int TOKEN_SMALL_STRING_PREFIX = 64;
    static final int TOKEN_SMALL_POS_INT_PREFIX = 128;
    static final int TOKEN_SMALL_NEG_INT_PREFIX = 160;
    private final OutputStream out;
    private final HashMap<String, Integer> keys = new HashMap();

    BonWriter(OutputStream out) throws IOException {
        this.out = out;
        out.write(66);
        out.write(79);
        out.write(78);
        out.write(0);
    }

    void writeValue(Object obj) throws IOException {
        if (obj == null) {
            this.out.write(33);
        } else {
            ClassWrapper wrapper = ClassWrapper.getWrapper(obj.getClass());
            int jsonType = wrapper.getJsonType();
            switch (jsonType) {
                case 8: {
                    this.writeNumber(((Date)obj).getTime());
                    return;
                }
                case 9: {
                    this.out.write((Boolean)obj != false ? 35 : 34);
                    return;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    this.writeNumber(((Number)obj).longValue());
                    return;
                }
                case 16: {
                    this.writeNumber(((Character)obj).charValue());
                    return;
                }
                case 14: {
                    this.writeNumber(((Float)obj).floatValue());
                    return;
                }
                case 15: {
                    this.writeNumber((Double)obj);
                    return;
                }
                case 2: {
                    this.writeString(obj.toString());
                    return;
                }
                case 3: {
                    this.writeCollection((Collection)obj);
                    break;
                }
                case 4: {
                    this.writeMap((Map)obj);
                    break;
                }
                case 5: {
                    this.writeArray(obj);
                    return;
                }
                case 17: {
                    this.writeBytes((byte[])obj);
                    return;
                }
                case 6: {
                    this.writeString(((Enum)obj).name());
                    return;
                }
                case 7: {
                    this.writeObject(obj, wrapper);
                    return;
                }
                default: {
                    throw new JsonException("Unknown json type: " + jsonType);
                }
            }
        }
    }

    private void writeString(String str) throws IOException {
        int length = str.length();
        if (length <= 31) {
            this.out.write(64 + length);
        } else {
            this.out.write(44);
            this.writeNumberDigits(length);
        }
        UTF8StreamWriter writer = new UTF8StreamWriter(this.out);
        writer.write(str);
        writer.flushSurrogate();
    }

    private void writeBytes(byte[] bytes) throws IOException {
        this.out.write(45);
        this.writeNumberDigits(bytes.length);
        this.out.write(bytes);
    }

    private void writeArray(Object array) throws IOException {
        this.out.write(40);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            this.writeValue(Array.get(array, i));
        }
        this.out.write(43);
    }

    private void writeCollection(Collection<?> collection) throws IOException {
        this.out.write(40);
        for (Object obj : collection) {
            this.writeValue(obj);
        }
        this.out.write(43);
    }

    private void writeMap(Map<?, ?> map) throws IOException {
        this.out.write(42);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.writeValue(entry.getKey());
            this.writeValue(entry.getValue());
        }
        this.out.write(43);
    }

    private void writeObject(Object obj, ClassWrapper wrapper) throws IOException {
        this.out.write(41);
        Field[] fields = wrapper.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = fields[i];
                String name = field.getName();
                Integer keyNr = this.keys.get(name);
                if (keyNr == null) {
                    this.writeString(name);
                    this.keys.put(name, this.keys.size());
                } else {
                    this.writeNumber(keyNr.intValue());
                }
                this.writeValue(field.get(obj));
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace(System.err);
                continue;
            }
            catch (StackOverflowError ex) {
                JsonException jsonEx = new JsonException(String.valueOf(obj));
                jsonEx.setStackTrace(new StackTraceElement[0]);
                ex.addSuppressed(jsonEx);
                if (ex.getSuppressed().length == 0) {
                    StackOverflowError ex2 = new StackOverflowError(ex.getMessage());
                    ex2.addSuppressed(jsonEx);
                    if (ex2.getSuppressed().length > 0) {
                        ex2.setStackTrace(ex.getStackTrace());
                        throw ex2;
                    }
                }
                throw ex;
            }
        }
        this.out.write(43);
    }

    private void writeNumber(float num) throws IOException {
        int intValue = (int)num;
        if ((float)intValue == num && intValue < 0x200000 && intValue >= -2097152) {
            this.writeNumber(intValue);
            return;
        }
        int bits = Float.floatToIntBits(num);
        this.out.write(38);
        this.out.write(bits >> 24);
        this.out.write(bits >> 16);
        this.out.write(bits >> 8);
        this.out.write(bits);
    }

    private void writeNumber(double num) throws IOException {
        long intValue = (long)num;
        if ((double)intValue == num && intValue < 0x200000L && intValue >= -2097152L) {
            this.writeNumber(intValue);
            return;
        }
        long bits = Double.doubleToLongBits(num);
        this.out.write(39);
        this.out.write((int)(bits >> 56));
        this.out.write((int)(bits >> 48));
        this.out.write((int)(bits >> 40));
        this.out.write((int)(bits >> 32));
        this.out.write((int)(bits >> 24));
        this.out.write((int)(bits >> 16));
        this.out.write((int)(bits >> 8));
        this.out.write((int)bits);
    }

    private void writeNumber(long num) throws IOException {
        if (num >= 0L) {
            if (num <= 31L) {
                this.out.write(128 + (int)num);
                return;
            }
            this.out.write(36);
        } else {
            if ((num ^= 0xFFFFFFFFFFFFFFFFL) <= 31L) {
                this.out.write(160 + (int)num);
                return;
            }
            this.out.write(37);
        }
        this.writeNumberDigits(num);
    }

    private void writeNumberDigits(long num) throws IOException {
        this.writeNumberDigitRecursivly(num >>> 7);
        this.out.write((byte)(128L + (num & 0x7FL)));
    }

    private void writeNumberDigitRecursivly(long num) throws IOException {
        if (num == 0L) {
            return;
        }
        this.writeNumberDigitRecursivly(num >>> 7);
        this.out.write((byte)(num & 0x7FL));
    }
}

