/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;

public class UTF8StreamReader
extends Reader {
    private final InputStream input;
    private int surrogate;
    private boolean scanBOM = true;

    public UTF8StreamReader(InputStream input) {
        this.input = input;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = off;
        while (off < len) {
            int ch = this.read();
            if (ch < 0) {
                return off > count ? off - count : -1;
            }
            cbuf[off] = (char)ch;
            ++off;
        }
        return off - count;
    }

    @Override
    public int read() throws IOException {
        if (this.scanBOM) {
            this.scanBOM = false;
            int ch = this.read0();
            if (ch != 65279) {
                return ch;
            }
        }
        return this.read0();
    }

    private int read0() throws IOException {
        if (this.surrogate != 0) {
            int temp = this.surrogate;
            this.surrogate = 0;
            return temp;
        }
        int c = this.input.read();
        if (c < 0) {
            return -1;
        }
        switch (c >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return c;
            }
            case 12: 
            case 13: {
                int char2 = this.readContinuationByte();
                return (char)((c & 0x1F) << 6 | char2 & 0x3F);
            }
            case 14: {
                int char2 = this.readContinuationByte();
                int char3 = this.readContinuationByte();
                return (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
            }
            case 15: {
                if ((c & 8) != 0) {
                    throw new UTFDataFormatException("malformed input around byte " + c);
                }
                int char2 = this.readContinuationByte();
                int char3 = this.readContinuationByte();
                int char4 = this.readContinuationByte();
                int result = (c & 7) << 18 | (char2 & 0x3F) << 12 | (char3 & 0x3F) << 6 | (char4 & 0x3F) << 0;
                this.surrogate = 0xDC00 | (result -= 65536) & 0x3FF;
                return (char)(0xD800 | result >> 10);
            }
        }
        throw new UTFDataFormatException("malformed input around byte " + c);
    }

    private int readContinuationByte() throws IOException, UTFDataFormatException {
        int b = this.input.read();
        if ((b & 0xC0) != 128) {
            throw new UTFDataFormatException("malformed input around byte " + b);
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.input.available() > 0;
    }
}

