/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client;

import com.inet.lib.json.Json;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.logging.Logger;
import com.inet.pdfc.generator.ComparatorProperties;
import com.inet.pdfc.generator.ComparatorProperty;
import com.inet.pdfc.generator.DataGeneratorListener;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.PageData;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.remote.client.PdfcServerInfo;
import com.inet.pdfc.remote.client.impl.ByteBufferInputStream;
import com.inet.pdfc.remote.client.impl.ConsoleLogger;
import com.inet.pdfc.remote.client.impl.RPCImageStore;
import com.inet.pdfc.remote.client.impl.RPCTypeResolver;
import com.inet.pdfc.rpc.model.EventCommand;
import com.inet.pdfc.rpc.model.JSONEvent;
import com.inet.pdfc.rpc.model.ResultVerbosity;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class RPCClient
implements Closeable {
    private static Logger logger = new ConsoleLogger();
    private RPCClientEndpoint endpoint;
    private CountDownLatch latch = new CountDownLatch(1);
    private PdfcServerInfo server;
    private PdfData expected;
    private PdfData actual;
    private Properties config;
    private String configName;
    private ComparatorProperties properties = new ComparatorProperties();
    private ResultVerbosity resultVerbosity = ResultVerbosity.differenceCount;
    private DataGeneratorListener listener;
    private boolean canceled = false;
    private RPCImageStore store = new RPCImageStore();
    private int differencesCount = -1;
    private Throwable error;

    public RPCClient() {
        this.properties.setComparerProperty(ComparatorProperty.createImages, "false");
        this.properties.setComparerProperty(ComparatorProperty.createTextSelectionData, "false");
        this.properties.setComparerProperty(ComparatorProperty.createHighlightData, "false");
    }

    public static void setLogger(Logger logger) {
        RPCClient.logger = logger != null ? logger : new ConsoleLogger();
    }

    public static Logger getLogger() {
        return logger;
    }

    public void setExpected(File expected) {
        if (expected.isDirectory() || !expected.canRead()) {
            throw new IllegalArgumentException("The file " + expected + " is not a readable file");
        }
        this.expected = new PdfData(expected);
    }

    public void setExpected(PdfData expected) {
        this.expected = expected;
    }

    public void setExpected(String name, ByteBuffer data) {
        this.expected = new PdfData(name, data);
    }

    public void setActual(File actual) {
        if (actual.isDirectory() || !actual.canRead()) {
            throw new IllegalArgumentException("The file " + actual + " is not a readable file");
        }
        this.actual = new PdfData(actual);
    }

    public void setActual(PdfData actual) {
        this.actual = actual;
    }

    public void setActual(String name, ByteBuffer data) {
        this.actual = new PdfData(name, data);
    }

    public Throwable getError() {
        return this.error;
    }

    private void setError(Throwable th) {
        if (this.error == null) {
            this.error = th;
        } else {
            this.error.addSuppressed(th);
        }
    }

    public void setServerInfo(PdfcServerInfo server) {
        this.server = server;
    }

    public PdfcServerInfo getServerInfo() {
        if (this.server == null) {
            this.server = new PdfcServerInfo();
        }
        return this.server;
    }

    private void connect() throws IOException {
        if (this.endpoint != null) {
            logger.info("Already connected, using existing session " + this.endpoint.currentSession.getId());
            this.endpoint.currentSession.getAsyncRemote().sendText(JSONEvent.toJSON(EventCommand.HANDSHAKE, null));
            return;
        }
        try {
            this.getServerInfo().init();
            ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

                public void beforeRequest(Map<String, List<String>> headers) {
                    List<String> cookies = RPCClient.this.server.getCookies();
                    StringBuilder builder = new StringBuilder();
                    for (String cookie : cookies) {
                        if (builder.length() > 0) {
                            builder.append("; ");
                        }
                        builder.append(cookie);
                    }
                    headers.put("Cookie", Arrays.asList(builder.toString()));
                }
            };
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClientEndpointConfig clientConfig = ClientEndpointConfig.Builder.create().configurator(configurator).build();
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            try {
                this.endpoint = new RPCClientEndpoint();
                URI serverURL = new URI("ws" + this.server.getServicePath().substring(4));
                logger.info("Connecting to " + serverURL);
                container.connectToServer((Endpoint)this.endpoint, clientConfig, serverURL);
            }
            catch (IOException | URISyntaxException | DeploymentException e) {
                logger.error(e);
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
        catch (LinkageError | RuntimeException e) {
            logger.error(e);
            String msg = "The RPC client of i-net PDFC requires support libraries for web sockets.\nPlease add the following dependencies to your Gradle project:Mandatory: 'javax.websocket:javax.websocket-api:1.0@jar'\nAlternatively: 'org.glassfish.tyrus:tyrus-client:1.+@jar' or 'org.eclipse.jetty.websocket:websocket-client:9.+@jar'\nYou may use any other implemenation of a JSR 356 Websocket client as well.";
            throw new RuntimeException(msg, e);
        }
    }

    private void await(CountDownLatch latch) {
        block2: {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                if (this.canceled) break block2;
                logger.error(e);
            }
        }
    }

    public void setConfiguration(Properties config) {
        this.config = config;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public int runComparison() throws IOException {
        this.connect();
        this.await(this.latch);
        return this.differencesCount;
    }

    public void setDataListener(@Nonnull DataGeneratorListener listener) {
        this.resultVerbosity = ResultVerbosity.progressiveModel;
        this.listener = listener;
    }

    public void setCreatePageImages(boolean doCreate) {
        this.properties.setComparerProperty(ComparatorProperty.createImages, Boolean.toString(doCreate));
    }

    public void setCreateTextSelectionData(boolean doCreate) {
        this.properties.setComparerProperty(ComparatorProperty.createTextSelectionData, Boolean.toString(doCreate));
    }

    public void setCreateCreateAnnotationData(boolean doCreate) {
        this.properties.setComparerProperty(ComparatorProperty.createHighlightData, Boolean.toString(doCreate));
    }

    public void cancel() {
        this.canceled = true;
        try {
            if (this.endpoint != null) {
                this.endpoint.currentSession.getAsyncRemote().sendText(JSONEvent.toJSON(EventCommand.CANCEL, null));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.endpoint != null) {
            this.endpoint.close();
        }
    }

    public PageImageCache getStore() {
        return this.store;
    }

    static /* synthetic */ RPCImageStore access$600(RPCClient x0) {
        return x0.store;
    }

    static /* synthetic */ DataGeneratorListener access$700(RPCClient x0) {
        return x0.listener;
    }

    public static class PdfData {
        private File file;
        private String name;
        private ByteBuffer content;
        private URL url;
        private InputStream input;

        public PdfData(File file) {
            this.file = file;
            this.name = file.getName();
        }

        public PdfData(URL url) {
            this.url = url;
            this.name = url.getPath();
        }

        public PdfData(String name, InputStream input) {
            this.name = name;
            this.input = input;
        }

        public PdfData(String name, ByteBuffer content) {
            this.name = name;
            this.content = content;
        }

        private InputStream getInputStream() throws IOException {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            if (this.content != null) {
                return new ByteBufferInputStream(this.content);
            }
            if (this.url != null) {
                return this.url.openStream();
            }
            if (this.input != null) {
                return this.input;
            }
            throw new IOException("No file content available");
        }

        private void sendContent(EventCommand command, Session session) throws IOException {
            RemoteEndpoint.Basic channel = session.getBasicRemote();
            try (InputStream in = this.getInputStream();){
                int len;
                byte[] read = new byte[65536];
                byte[] send = new byte[65536];
                byte[] event = (command.name() + '\n').getBytes();
                ByteBuffer binary = ByteBuffer.wrap(event, 0, event.length);
                while ((len = in.read(read)) >= 0) {
                    channel.sendBinary(binary, false);
                    byte[] buf = send;
                    send = read;
                    read = buf;
                    binary = ByteBuffer.wrap(send, 0, len);
                }
                channel.sendBinary(binary, true);
            }
        }

        private String getName() {
            return this.name;
        }
    }

    @ClientEndpoint
    private class RPCClientEndpoint
    extends Endpoint
    implements Closeable {
        private Session currentSession;
        private EventCommand currentCommand;
        private String nextJSONClass;

        private RPCClientEndpoint() {
        }

        public void onError(Session session, Throwable thr) {
            logger.error("Error in session " + session.getId());
            logger.error(thr);
            RPCClient.this.setError(thr);
            RPCClient.this.latch.countDown();
        }

        @OnOpen
        public void onOpen(final Session session, EndpointConfig config) {
            logger.info("Connected with session " + session.getId());
            this.currentSession = session;
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    RPCClientEndpoint.this.onMessage(message, session);
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer message) {
                    RPCClientEndpoint.this.onMessage(message, session);
                }
            });
            session.getAsyncRemote().sendText(JSONEvent.toJSON(EventCommand.HANDSHAKE, null));
        }

        /*
         * Unable to fully structure code
         */
        @OnMessage
        public void onMessage(ByteBuffer data, Session session) {
            RPCClient.access$300().debug("Received binary data for command " + (Object)this.currentCommand);
            switch (2.$SwitchMap$com$inet$pdfc$rpc$model$EventCommand[this.currentCommand.ordinal()]) {
                case 1: {
                    RPCClient.access$300().debug("Received image for key " + this.nextJSONClass);
                    if (RPCClient.access$600(RPCClient.this) == null) {
                        RPCClient.access$300().error("There is no image store registered to store the image" + this.nextJSONClass);
                        return;
                    }
                    RPCClient.access$600(RPCClient.this).storeImage(this.nextJSONClass, data);
                    break;
                }
                case 2: {
                    RPCClient.access$300().debug("Received result chunk of type " + this.nextJSONClass + " " + new String(data.array()));
                    if (RPCClient.access$700(RPCClient.this) == null) {
                        RPCClient.access$300().error("There is no DataGeneratorListener registered to process a '" + this.nextJSONClass + "' result chunk!");
                        return;
                    }
                    try {
                        clazz = Class.forName(this.nextJSONClass);
                    }
                    catch (ClassNotFoundException e) {
                        RPCClient.access$300().error(e);
                        return;
                    }
                    try {
                        reader = new InputStreamReader(new ByteBufferInputStream(data));
                        var5_7 = null;
                        chunk = new Json().fromJson((Reader)reader, clazz, (JsonTypeResolver)new RPCTypeResolver());
                        if (chunk instanceof Chunk) {
                            RPCClient.access$700(RPCClient.this).addData((Chunk)chunk);
                            if (chunk instanceof PageData) {
                                RPCClient.access$600(RPCClient.this).storePageData((PageData)chunk);
                            } else if (chunk instanceof ErrorData) {
                                RPCClient.access$300().error("An error has occured during comparison:\n" + ((ErrorData)chunk).getError());
                                RPCClient.access$500(RPCClient.this).countDown();
                            }
                        } else {
                            throw new IOException("Received invalid or unknown chunk type: " + this.nextJSONClass);
                        }
                        if (reader == null) break;
                        if (var5_7 == null) ** GOTO lbl44
                        try {
                            reader.close();
                        }
                        catch (Throwable var6_9) {
                            var5_7.addSuppressed(var6_9);
                        }
                        break;
lbl44:
                        // 1 sources

                        reader.close();
                        ** break;
                        catch (Throwable var6_10) {
                            try {
                                var5_7 = var6_10;
                                throw var6_10;
                            }
                            catch (Throwable var7_11) {
                                if (reader != null) {
                                    if (var5_7 != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable var8_12) {
                                            var5_7.addSuppressed(var8_12);
                                        }
                                    } else {
                                        reader.close();
                                    }
                                }
                                throw var7_11;
lbl61:
                                // 1 sources

                            }
                        }
                    }
                    catch (IOException e) {
                        this.onError(session, e);
                    }
                    break;
                }
                default: {
                    RPCClient.access$300().error("Received unexpected binary data for event '" + (Object)this.currentCommand + "'. This binary data will be ignored.");
                }
            }
        }

        @OnMessage
        public void onMessage(String message, Session session) {
            try {
                EventCommand command;
                JSONEvent event = JSONEvent.fromJSON(message);
                this.currentCommand = command = event.getCommand();
                logger.debug("Received command " + (Object)((Object)command));
                switch (command) {
                    case LOGIN_REQUIRED: {
                        logger.error("Login required for session " + session.getId());
                        break;
                    }
                    case HANDSHAKE: {
                        this.sendConfig();
                        this.sendProperties();
                        session.getAsyncRemote().sendText(JSONEvent.toJSON(EventCommand.RESULT_VERBOSITY, (Object)RPCClient.this.resultVerbosity));
                        this.uploadPdf(RPCClient.this.expected, true);
                        this.uploadPdf(RPCClient.this.actual, false);
                        break;
                    }
                    case SEND_RESULT: {
                        RPCClient.this.differencesCount = (Integer)event.getPayload();
                        logger.debug("Difference count for session " + session.getId() + " is " + RPCClient.this.differencesCount);
                        break;
                    }
                    case IMAGE: 
                    case CHUNK: {
                        this.nextJSONClass = (String)event.getPayload();
                        logger.debug("Setting next payload type to: " + this.nextJSONClass);
                        break;
                    }
                    case error: {
                        String msg = "An error occurred on the server: " + event.getPayload();
                        this.onError(session, new IllegalStateException(msg));
                        break;
                    }
                    case CANCEL: {
                        logger.info("Session '" + session.getId() + "' is canceled");
                        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Terminated due to a cancellation request"));
                        break;
                    }
                    case QUIT: {
                        logger.info("Session '" + session.getId() + "' is closed");
                        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Comparison done"));
                        break;
                    }
                    default: {
                        logger.error("Received unexpected text data for event '" + (Object)((Object)this.currentCommand) + "'. This text data will be ignored.");
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.onError(session, ex);
            }
        }

        @OnClose
        public void onClose(Session session, CloseReason closeReason) {
            logger.info(String.format("Session %s close because of %s", session.getId(), closeReason));
            if (closeReason != null) {
                switch (closeReason.getCloseCode().getCode()) {
                    case 1002: 
                    case 1006: 
                    case 1011: {
                        RPCClient.this.setError(new IllegalStateException(closeReason.getReasonPhrase()));
                    }
                }
            }
            RPCClient.this.latch.countDown();
        }

        private void sendConfig() throws IOException {
            if (RPCClient.this.config == null && RPCClient.this.configName == null) {
                return;
            }
            if (RPCClient.this.config == null) {
                logger.info("Sending config per name for session " + this.currentSession.getId());
                JSONEvent event = new JSONEvent(EventCommand.COMPARE_CONFIGURATION_NAME, RPCClient.this.configName);
                this.currentSession.getBasicRemote().sendText(event.getJSON());
                return;
            }
            logger.info("Sending config for session " + this.currentSession.getId());
            JSONEvent event = new JSONEvent(EventCommand.COMPARE_CONFIG, RPCClient.this.config);
            this.currentSession.getBasicRemote().sendText(event.getJSON());
        }

        private void sendProperties() throws IOException {
            if (RPCClient.this.properties == null) {
                return;
            }
            logger.info("Sending comparison properties for session " + this.currentSession.getId());
            JSONEvent event = new JSONEvent(EventCommand.COMPARE_PROPERTIES, RPCClient.this.properties);
            this.currentSession.getBasicRemote().sendText(event.getJSON());
        }

        private void uploadPdf(PdfData pdf, boolean first) {
            try {
                JSONEvent event = new JSONEvent(first ? EventCommand.PDF_EXPECTED : EventCommand.PDF_ACTUAL, pdf.getName());
                RemoteEndpoint.Basic basic = this.currentSession.getBasicRemote();
                logger.info("Sending file " + pdf.getName() + " for session " + this.currentSession.getId());
                basic.sendText(event.getJSON());
                pdf.sendContent(first ? EventCommand.PDF_EXPECTED_DATA : EventCommand.PDF_ACTUAL_DATA, this.currentSession);
            }
            catch (IOException e) {
                logger.error(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.currentSession != null && this.currentSession.isOpen()) {
                this.currentSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Comparison done"));
            }
        }
    }
}

