/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.diff;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.i18n.Msg;
import java.io.Serializable;

@JsonData
@PublicApi
public abstract class AttributeDifference<T>
implements Comparable<AttributeDifference<?>>,
Serializable {
    private transient T oldValue;
    private transient T newValue;
    private TYPE instanceType;
    private String messageKey;
    private String oldValueDescriptor;
    private String newValueDescriptor;

    private AttributeDifference() {
    }

    private AttributeDifference(T oldValue, T newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.oldValueDescriptor = this.formatValue(oldValue);
        this.newValueDescriptor = this.formatValue(newValue);
    }

    public AttributeDifference(TYPE instanceType, T oldValue, T newValue, String messageKey) {
        this(oldValue, newValue);
        this.instanceType = instanceType;
        this.messageKey = messageKey;
    }

    String formatValue(T value) {
        return String.valueOf(value);
    }

    String getMessageKey() {
        return this.messageKey;
    }

    public String getMessage() {
        return Msg.getMsg(this.getMessageKey(), this.oldValue, this.newValue);
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDifference other = (AttributeDifference)obj;
        return this.isEqual(other.getOldValue(), this.getOldValue()) && this.isEqual(other.getNewValue(), this.getNewValue());
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    @Override
    public int compareTo(AttributeDifference<?> o) {
        if (this.getClass() != o.getClass()) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return 0;
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public TYPE getInstanceType() {
        return this.instanceType;
    }

    public String getOldValueDescriptor() {
        return this.oldValueDescriptor;
    }

    public String getNewValueDescriptor() {
        return this.newValueDescriptor;
    }

    @PublicApi
    public static enum TYPE {
        ABSTRACT_COLOR,
        SHAPEFILL,
        CHECKED,
        CURVE_POINT,
        CURVE_TYPE,
        FONT_FAMILY,
        FONT_STYLE,
        FONT_SIZE,
        FONT_COLOR,
        IMG_CONTENT,
        IMG_PARTCONTENT,
        IMG_SIZE,
        LINE_SIZE,
        LINE_STYLE,
        LINE_THICKNESS,
        LINE_COLOR,
        MINIFIED,
        ASPECT_RATIO,
        PAGE_BOX_BOUNDS,
        PAGE_BOX_SIZE,
        PAGE_BOX_LOC,
        PAGE_MARGIN,
        PAGE_ROTATION,
        TEXT_CONTROL,
        TEXT_LOC,
        TEXT_ROTATION,
        UNDERLINE,
        UNDERLINE_LENGTH,
        LANG_UNSUPPORTED,
        LANG_DIFFERENT;

    }
}

