/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonParser;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.lib.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;

public class Json {
    public static final Charset UTF8 = Charset.forName("UTF8");

    public <T> T fromJson(InputStream input, Class<T> clazz) throws IOException {
        return this.fromJson(input, clazz, null, null);
    }

    public <T> T fromJson(InputStream input, Class<T> clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(input, clazz, null, typeResolver);
    }

    public <T> T fromJson(InputStream input, Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson((Reader)new UTF8StreamReader(input), clazz, extraFields, typeResolver);
    }

    public <T> T fromJson(String jsonData, Class<T> clazz) {
        return this.fromJson(jsonData, (Type)clazz, null, null);
    }

    public <T> T fromJson(String jsonData, Class<T> clazz, JsonTypeResolver typeResolver) {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    public <T> T fromJson(String jsonData, Type clazz) {
        return this.fromJson(jsonData, clazz, null, null);
    }

    public <T> T fromJson(String jsonData, Type clazz, Map<Object, Map<String, String>> extraFields) {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    public <T> T fromJson(String jsonData, Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) {
        try {
            return this.fromJson((Reader)new FastStringReader(jsonData), clazz, extraFields, typeResolver);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public <T> T fromJson(Reader jsonData, Class<T> clazz) throws IOException {
        return this.fromJson(jsonData, (Type)clazz, null, null);
    }

    public <T> T fromJson(Reader jsonData, Class<T> clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    public <T> T fromJson(Reader jsonData, Class<T> clazz, Map<Object, Map<String, String>> extraFields) throws IOException {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    public <T> T fromJson(Reader jsonData, Type clazz) throws IOException {
        return this.fromJson(jsonData, clazz, null, null);
    }

    public <T> T fromJson(Reader jsonData, Type clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    public <T> T fromJson(Reader jsonData, Type clazz, Map<Object, Map<String, String>> extraFields) throws IOException {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    public <T> T fromJson(Reader jsonData, Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        try {
            if (typeResolver == null) {
                typeResolver = JsonTypeResolver.INSTANCE;
            }
            JsonParser parser = new JsonParser(jsonData, extraFields, typeResolver);
            return (T)parser.parseValue(clazz);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public <T> T fromJson(String jsonData, Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((Reader)new FastStringReader(jsonData), clazz, generic);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public <T> T fromJson(Reader jsonData, Class<T> clazz, Type ... generic) throws IOException {
        try {
            JsonParser parser = new JsonParser(jsonData, null, JsonTypeResolver.INSTANCE);
            return (T)parser.parseValue(new JsonParameterizedType(clazz, generic));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public Object[] fromJson(Reader jsonData, Type[] classes) throws IOException {
        try {
            JsonParser parser = new JsonParser(jsonData, null, JsonTypeResolver.INSTANCE);
            return parser.parseValues(classes);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public String toJson(Object data) {
        StringBuilder buffer = new StringBuilder();
        this.toJson(data, buffer);
        return buffer.toString();
    }

    public void toJson(Object value, Appendable writer) throws IOException {
        try {
            JsonWriter parser = new JsonWriter(writer);
            parser.writeValue(value);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public void toJson(Object value, StringBuilder builder) {
        try {
            JsonWriter parser = new JsonWriter(builder);
            parser.writeValue(value);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public void toJson(Object value, OutputStream output) throws IOException {
        UTF8StreamWriter writer = new UTF8StreamWriter(output);
        this.toJson(value, writer);
        try {
            writer.flush();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public static <T> void registerTypeResolver(Class<T> clazz, JsonSubTypeResolver<T> resolver) {
        ClassWrapper.getWrapper(clazz).setSubTypeResolver(resolver);
    }
}

