/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.rpc.model;

import com.inet.annotations.JsonData;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.pdfc.rpc.model.EventCommand;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class JSONEvent {
    private static final JsonTypeResolver TYPE_RESOLVER = new JsonTypeResolver(){

        @Override
        protected Type getGenericType(Object obj, Field field) {
            JSONEvent jsonEvent;
            if (field.getDeclaringClass() == JSONEvent.class && field.getName().equals("data") && (jsonEvent = (JSONEvent)obj).event != null) {
                return jsonEvent.event.getPayloadType();
            }
            return super.getGenericType(obj, field);
        }
    };
    private EventCommand event;
    private Object data;

    private JSONEvent() {
    }

    public JSONEvent(@Nonnull EventCommand command, @Nullable Object payload) {
        this.event = command;
        this.data = payload;
    }

    public static JSONEvent fromJSON(String json) throws IOException {
        return new Json().fromJson((Reader)new EncodedReader(new FastStringReader(json)), JSONEvent.class, TYPE_RESOLVER);
    }

    public static String toJSON(@Nonnull EventCommand command, @Nullable Object payload) {
        return new JSONEvent(command, payload).getJSON();
    }

    @Nonnull
    public EventCommand getCommand() {
        return this.event;
    }

    @Nullable
    public <T> T getPayload() {
        return (T)this.data;
    }

    @Nonnull
    public String getJSON() {
        return new Json().toJson(this);
    }
}

