/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model.controls;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.Clip;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementList;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.model.controls.ControlElement;
import java.awt.geom.Rectangle2D;
import java.util.List;

@InternalApi
public class ControlText
extends ControlElement {
    public ControlText(String fieldName, String fieldValue, int pageIndex, Rectangle2D bounds) {
        super(fieldName, fieldValue, pageIndex, bounds);
    }

    @Override
    public String getFieldValue() {
        String value = super.getFieldValue();
        if (value == null) {
            StringBuilder strBuilder = new StringBuilder();
            ElementList list = this.getObjectList();
            if (list != null) {
                List<Clip> clips = list.getClips();
                for (Clip clip : clips) {
                    Rectangle2D bounds = clip.getBounds();
                    List<DrawableElement> elements = clip.getElements();
                    for (DrawableElement drawableElement : elements) {
                        if (!(drawableElement instanceof TextElement)) continue;
                        TextElement pdfText = (TextElement)drawableElement;
                        pdfText.setClip(bounds);
                        strBuilder.append(pdfText.getText());
                    }
                }
                value = strBuilder.toString();
                this.setFieldValue(value);
            }
        }
        return value;
    }

    @Override
    public boolean isStateUndefined() {
        return false;
    }

    @Override
    public int getCompareHash() {
        return 4711;
    }

    @Override
    public ElementType getType() {
        return ElementType.ControlText;
    }
}

