/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@JsonData
@PublicApi
public class DefaultProfile
implements IProfile {
    private Properties properties = new Properties();
    private transient Set<ProfileChangeListener> listeners = new HashSet<ProfileChangeListener>();

    public DefaultProfile() {
    }

    public DefaultProfile(IProfile sourceProfile) {
        for (PDFCProperty<?> key : PDFCProperty.values()) {
            this.putValue(key, String.valueOf(sourceProfile.getObject(key)));
        }
        this.putValue("PROFIL_NAME", sourceProfile.getString("PROFIL_NAME"));
        this.putValue("PROFIL_DESCRIPTION", sourceProfile.getString("PROFIL_DESCRIPTION"));
    }

    public void addProfileChangeListener(ProfileChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeProfileChangeListener(ProfileChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public boolean getBool(String propertyName) {
        Object obj = this.getObject(propertyName);
        return obj != null && Boolean.parseBoolean(obj.toString());
    }

    @Override
    public int getInt(String propertyName) {
        Object obj = this.getObject(propertyName);
        if (obj != null) {
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                return (int)Math.round(Double.parseDouble(obj.toString()));
            }
        }
        return 0;
    }

    @Override
    public double getDouble(String propertyName) {
        Object obj = this.getObject(propertyName);
        if (obj != null) {
            try {
                return Double.parseDouble(obj.toString());
            }
            catch (Exception e) {
                try {
                    return DecimalFormat.getNumberInstance(Locale.US).parse(obj.toString()).doubleValue();
                }
                catch (Exception e2) {
                    return 0.0;
                }
            }
        }
        return 0.0;
    }

    @Override
    public Object getObject(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        Object val = this.properties.get(propertyName);
        if (val == null) {
            PDFCProperty<?> prop = PDFCProperty.valueOf(propertyName);
            return prop != null ? prop.getDefaultValue() : null;
        }
        return val;
    }

    @Override
    public String getString(String propertyName) {
        Object obj = this.getObject(propertyName);
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    @Override
    public void putValue(PDFCProperty<?> property, String value) {
        if (property != null) {
            this.properties.put(property.name(), value);
            for (ProfileChangeListener l : this.listeners) {
                l.onPropertyUpdate(property, (Object)value);
            }
        }
    }

    @Override
    public void putValue(String propertyName, String value) {
        if (propertyName != null) {
            this.properties.put(propertyName, value.toString());
            for (ProfileChangeListener l : this.listeners) {
                l.onPropertyUpdate(propertyName, (Object)value);
            }
        }
    }

    @Override
    public void putValues(Properties values) {
        if (values != null) {
            HashMap<String, String> changedProperties = new HashMap<String, String>();
            for (Object object : values.keySet()) {
                if (!(object instanceof String)) continue;
                String strKey = (String)object;
                String oldValue = this.properties.getProperty(strKey);
                String newValue = values.getProperty(strKey);
                boolean changed = oldValue == null || !oldValue.equals(newValue);
                if (!changed) continue;
                changedProperties.put(strKey, newValue);
                this.properties.setProperty(strKey, newValue);
            }
            for (Map.Entry entry : changedProperties.entrySet()) {
                for (ProfileChangeListener l : this.listeners) {
                    l.onPropertyUpdate((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Object getObject(PDFCProperty<?> property) {
        return this.getObject(property != null ? property.name() : null);
    }

    @Override
    public String getString(PDFCProperty<?> property) {
        return this.getString(property != null ? property.name() : null);
    }

    @Override
    public int getInt(PDFCProperty<?> property) {
        return this.getInt(property != null ? property.name() : null);
    }

    @Override
    public double getDouble(PDFCProperty<?> property) {
        return this.getDouble(property != null ? property.name() : null);
    }

    @Override
    public boolean getBool(PDFCProperty<?> property) {
        return this.getBool(property != null ? property.name() : null);
    }

    public static interface ProfileChangeListener {
        public void onPropertyUpdate(PDFCProperty<?> var1, Object var2);

        public void onPropertyUpdate(String var1, Object var2);
    }
}

