/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.PDFCPropertyUpdater;
import com.inet.pdfc.config.ValidValueProvider;
import com.inet.pdfc.i18n.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@InternalApi
public class LanguageValues
extends ValidValueProvider {
    public static LanguageValues DEFAULT_INSTANCE = new LanguageValues();
    public static final String KEY_ENGLISH = "eng";
    public static final String KEY_AUTO_DETECT = "auto-detect";
    private List<ValidValueProvider.ValidValue> values = new ArrayList<ValidValueProvider.ValidValue>();
    public static final Map<String, String> TESS_MAP = new HashMap<String, String>(){
        {
            this.put("afr", "afr");
            this.put("amh", "amh");
            this.put("ara", "ara");
            this.put("asm", "asm");
            this.put("aze", "aze");
            this.put("bel", "bel");
            this.put("ben", "ben");
            this.put("bod", "tib");
            this.put("bos", "bos");
            this.put("bre", "bre");
            this.put("bul", "bul");
            this.put("cat", "cat");
            this.put("ceb", "ceb");
            this.put("ces", "cze");
            this.put("chi", "chi");
            this.put("chr", "chr");
            this.put("cos", "cos");
            this.put("cym", "wel");
            this.put("dan", "dan");
            this.put("deu", "ger");
            this.put("div", "div");
            this.put("dzo", "dzo");
            this.put("ell", "gre");
            this.put(LanguageValues.KEY_ENGLISH, LanguageValues.KEY_ENGLISH);
            this.put("enm", "enm");
            this.put("epo", "epo");
            this.put("equ", "equ");
            this.put("est", "est");
            this.put("eus", "baq");
            this.put("fao", "fao");
            this.put("fas", "per");
            this.put("fil", "fil");
            this.put("fin", "fin");
            this.put("fra", "fre");
            this.put("frk", "frk");
            this.put("frm", "frm");
            this.put("fry", "fry");
            this.put("gla", "gla");
            this.put("gle", "gle");
            this.put("glg", "glg");
            this.put("grc", "grc");
            this.put("guj", "guj");
            this.put("hat", "hat");
            this.put("heb", "heb");
            this.put("hin", "hin");
            this.put("hrv", "hrv");
            this.put("hun", "hun");
            this.put("hye", "arm");
            this.put("iku", "iku");
            this.put("ind", "ind");
            this.put("isl", "ice");
            this.put("ita", "ita");
            this.put("jav", "jav");
            this.put("jpn", "jpn");
            this.put("kan", "kan");
            this.put("kat", "geo");
            this.put("kaz", "kaz");
            this.put("khm", "khm");
            this.put("kir", "kir");
            this.put("kor", "kor");
            this.put("kur", "kur");
            this.put("lao", "lao");
            this.put("lat", "lat");
            this.put("lav", "lav");
            this.put("lit", "lit");
            this.put("ltz", "ltz");
            this.put("mal", "mal");
            this.put("mar", "mar");
            this.put("mkd", "mac");
            this.put("mlt", "mlt");
            this.put("mon", "mon");
            this.put("mri", "mao");
            this.put("msa", "may");
            this.put("mya", "bur");
            this.put("nep", "nep");
            this.put("nld", "dut");
            this.put("nor", "nor");
            this.put("oci", "oci");
            this.put("ori", "ori");
            this.put("osd", "osd");
            this.put("pan", "pan");
            this.put("pol", "pol");
            this.put("por", "por");
            this.put("pus", "pus");
            this.put("que", "que");
            this.put("ron", "rum");
            this.put("rus", "rus");
            this.put("san", "san");
            this.put("sin", "sin");
            this.put("slk", "slo");
            this.put("slv", "slv");
            this.put("snd", "snd");
            this.put("spa", "spa");
            this.put("sqi", "alb");
            this.put("srp", "srp");
            this.put("sun", "sun");
            this.put("swa", "swa");
            this.put("swe", "swe");
            this.put("syr", "syr");
            this.put("tam", "tam");
            this.put("tat", "tat");
            this.put("tel", "tel");
            this.put("tgk", "tgk");
            this.put("tgl", "tgl");
            this.put("tha", "tha");
            this.put("tir", "tir");
            this.put("ton", "ton");
            this.put("tur", "tur");
            this.put("uig", "uig");
            this.put("ukr", "ukr");
            this.put("urd", "urd");
            this.put("uzb", "uzb");
            this.put("vie", "vie");
            this.put("yid", "yid");
            this.put("yor", "yor");
        }
    };
    public static final Map<String, String> ISO_TO_TESS = new HashMap<String, String>(){
        {
            this.put("aa", "aar");
            this.put("ab", "abk");
            this.put("ae", "ave");
            this.put("af", "afr");
            this.put("ak", "aka");
            this.put("am", "amh");
            this.put("an", "arg");
            this.put("ar", "ara");
            this.put("as", "asm");
            this.put("av", "ava");
            this.put("ay", "aym");
            this.put("az", "aze");
            this.put("ba", "bak");
            this.put("be", "bel");
            this.put("bg", "bul");
            this.put("bh", "bih");
            this.put("bi", "bis");
            this.put("bm", "bam");
            this.put("bn", "ben");
            this.put("bo", "tib");
            this.put("br", "bre");
            this.put("bs", "bos");
            this.put("ca", "cat");
            this.put("ce", "che");
            this.put("ch", "cha");
            this.put("co", "cos");
            this.put("cr", "cre");
            this.put("cs", "cze");
            this.put("cu", "chu");
            this.put("cv", "chv");
            this.put("cy", "wel");
            this.put("da", "dan");
            this.put("de", "ger");
            this.put("dv", "div");
            this.put("dz", "dzo");
            this.put("ee", "ewe");
            this.put("el", "gre");
            this.put("en", LanguageValues.KEY_ENGLISH);
            this.put("eo", "epo");
            this.put("es", "spa");
            this.put("et", "est");
            this.put("eu", "baq");
            this.put("fa", "per");
            this.put("ff", "ful");
            this.put("fi", "fin");
            this.put("fj", "fij");
            this.put("fl", "fil");
            this.put("fo", "fao");
            this.put("fr", "fre");
            this.put("fy", "fry");
            this.put("ga", "gle");
            this.put("gd", "gla");
            this.put("gl", "glg");
            this.put("gn", "grn");
            this.put("gu", "guj");
            this.put("gv", "glv");
            this.put("ha", "hau");
            this.put("he", "heb");
            this.put("hi", "hin");
            this.put("ho", "hmo");
            this.put("hr", "hrv");
            this.put("ht", "hat");
            this.put("hu", "hun");
            this.put("hy", "arm");
            this.put("hz", "her");
            this.put("ia", "ina");
            this.put("id", "ind");
            this.put("ie", "ile");
            this.put("ig", "ibo");
            this.put("ii", "iii");
            this.put("ik", "ipk");
            this.put("io", "ido");
            this.put("is", "ice");
            this.put("it", "ita");
            this.put("iu", "iku");
            this.put("ja", "jpn");
            this.put("jv", "jav");
            this.put("ka", "geo");
            this.put("kg", "kon");
            this.put("ki", "kik");
            this.put("kj", "kua");
            this.put("kk", "kaz");
            this.put("kl", "kal");
            this.put("km", "khm");
            this.put("kn", "kan");
            this.put("ko", "kor");
            this.put("kr", "kau");
            this.put("ks", "kas");
            this.put("ku", "kur");
            this.put("kv", "kom");
            this.put("kw", "cor");
            this.put("ky", "kir");
            this.put("la", "lat");
            this.put("lb", "ltz");
            this.put("lg", "lug");
            this.put("li", "lim");
            this.put("ln", "lin");
            this.put("lo", "lao");
            this.put("lt", "lit");
            this.put("lu", "lub");
            this.put("lv", "lav");
            this.put("mg", "mlg");
            this.put("mh", "mah");
            this.put("mi", "mao");
            this.put("mk", "mac");
            this.put("ml", "mal");
            this.put("mn", "mon");
            this.put("mr", "mar");
            this.put("ms", "may");
            this.put("mt", "mlt");
            this.put("my", "bur");
            this.put("na", "nau");
            this.put("nb", "nob");
            this.put("nd", "nde");
            this.put("ne", "nep");
            this.put("ng", "ndo");
            this.put("nl", "dut");
            this.put("nn", "nno");
            this.put("no", "nor");
            this.put("nr", "nbl");
            this.put("nv", "nav");
            this.put("ny", "nya");
            this.put("oc", "oci");
            this.put("oj", "oji");
            this.put("om", "orm");
            this.put("or", "ori");
            this.put("os", "oss");
            this.put("pa", "pan");
            this.put("pi", "pli");
            this.put("pl", "pol");
            this.put("ps", "pus");
            this.put("pt", "por");
            this.put("qu", "que");
            this.put("rm", "roh");
            this.put("rn", "run");
            this.put("mo", "mol");
            this.put("ru", "rus");
            this.put("rw", "kin");
            this.put("sa", "san");
            this.put("sc", "srd");
            this.put("sd", "snd");
            this.put("se", "sme");
            this.put("sg", "sag");
            this.put("si", "sin");
            this.put("sk", "slo");
            this.put("sl", "slv");
            this.put("sm", "smo");
            this.put("sn", "sna");
            this.put("so", "som");
            this.put("sq", "alb");
            this.put("sr", "srp");
            this.put("ss", "ssw");
            this.put("st", "sot");
            this.put("su", "sun");
            this.put("sv", "swe");
            this.put("sw", "swa");
            this.put("ta", "tam");
            this.put("te", "tel");
            this.put("tg", "tgk");
            this.put("th", "tha");
            this.put("ti", "tir");
            this.put("tk", "tuk");
            this.put("tl", "tgl");
            this.put("tn", "tsn");
            this.put("to", "ton");
            this.put("tr", "tur");
            this.put("ts", "tso");
            this.put("tt", "tat");
            this.put("tw", "twi");
            this.put("of", "Reo");
            this.put("ug", "uig");
            this.put("uk", "ukr");
            this.put("ur", "urd");
            this.put("uz", "uzb");
            this.put("ve", "ven");
            this.put("vi", "vie");
            this.put("vo", "vol");
            this.put("wa", "wln");
            this.put("wo", "wol");
            this.put("xh", "xho");
            this.put("yi", "yid");
            this.put("yo", "yor");
            this.put("za", "zha");
            this.put("zh", "chi");
            this.put("zu", "zul");
        }
    };

    public LanguageValues() {
        super(new Object[0]);
        this.values.add(new LanguageEntry(KEY_ENGLISH, () -> Msg.getMsg("language.eng")));
    }

    @Override
    public List<ValidValueProvider.ValidValue> getValidValues() {
        return this.values;
    }

    public void setAutoEnabled(boolean enabled) {
        if (enabled) {
            if (!KEY_AUTO_DETECT.equals(this.values.get(0).getProfileValue())) {
                this.values.add(0, new LanguageEntry(KEY_AUTO_DETECT, () -> Msg.getMsg("language.auto")));
                PDFCPropertyUpdater.modifyDefault(PDFCProperty.DOCUMENT_LANGUAGE, KEY_AUTO_DETECT);
            }
        } else if (KEY_AUTO_DETECT.equals(this.values.get(0).getProfileValue())) {
            this.values.remove(0);
            PDFCPropertyUpdater.modifyDefault(PDFCProperty.DOCUMENT_LANGUAGE, null);
        }
    }

    public void addLanguage(String key, Supplier<String> displayValueSupplier) {
        if (this.values.stream().filter(v -> v.getProfileValue().equals(key)).findFirst().isPresent()) {
            return;
        }
        this.values.add(new LanguageEntry(key, displayValueSupplier));
    }

    private static class LanguageEntry
    implements ValidValueProvider.ValidValue {
        private String profileKey;
        private Supplier<String> displayValueSupplier;

        public LanguageEntry(String profileKey, Supplier<String> displayValueSupplier) {
            this.profileKey = profileKey;
            this.displayValueSupplier = displayValueSupplier;
        }

        @Override
        public String getProfileValue() {
            return this.profileKey;
        }

        @Override
        public String getDisplayString() {
            return this.displayValueSupplier.get();
        }
    }
}

