/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.ObjectSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.SettingsControl;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.print.DefaultColorProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class DefaultSetting
implements Settings {
    private Properties settings = new Properties();
    private static List<ObjectSetting<?>> OBJECT_SETTINGS = new ArrayList();

    static synchronized void addObjectSetting(ObjectSetting<?> objectSetting) {
        OBJECT_SETTINGS.add(objectSetting);
    }

    public DefaultSetting() {
        DefaultColorProvider defaultColorProvider = new DefaultColorProvider();
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            this.setMarkerColor(defaultColorProvider.getMarkerColor(groupType), groupType);
            this.setColor(defaultColorProvider.getOutlineColor(groupType), groupType);
        }
        this.setColor(Color.blue, Settings.METAOPTION.ALLOUTLINEMARKER);
        this.setEnabled(true, Settings.EXPORT.HEADER, Settings.EXPORT.FOOTER, Settings.EXPORT.COMMENTS);
        this.setEnabled(false, Settings.EXPORT.SCALETOPAGEHEIGHT, Settings.EXPORT.CREATE_ORIGIMAGES, Settings.EXPORT.ONLY_ON_DIFFERENCES, Settings.EXPORT.CREATE_XORIMAGES, Settings.EXPORT.CREATE_DIFFIMAGES_FIRST, Settings.EXPORT.CREATE_DIFFIMAGES_SECOND);
        this.setEnabled(true, DiffGroup.GroupType.valuesVisible());
        this.setEnabled(false, Settings.OPTION.values());
    }

    @Override
    public synchronized List<ObjectSetting<?>> getAllObjectSettingNames() {
        return new ArrayList(OBJECT_SETTINGS);
    }

    @Override
    public void setMarkerColor(@Nonnull Color color, @Nonnull DiffGroup.GroupType content) {
        this.settings.put(SettingsControl.getKey(content, SettingsControl.PURPOSE.marker), Integer.toString(color.getRGB()));
    }

    @Override
    public void setColor(Color color, @Nonnull ColorSetting setting) {
        this.settings.put(SettingsControl.getKey(setting, SettingsControl.PURPOSE.color), Integer.toString(color.getRGB()));
    }

    @Override
    public void setEnabled(boolean isVisible, VisibilitySetting ... visibles) {
        for (VisibilitySetting visible : visibles) {
            this.settings.put(SettingsControl.getKey(visible, SettingsControl.PURPOSE.visibility), Boolean.toString(isVisible));
        }
    }

    @Override
    public boolean isEnabled(VisibilitySetting content) {
        return this.settings.getProperty(SettingsControl.getKey(content, SettingsControl.PURPOSE.visibility), !content.getTyp().equals("OPTION") + "").equalsIgnoreCase("true");
    }

    @Override
    @Nonnull
    public Color getMarkerColor(@Nonnull DiffGroup.GroupType content) {
        return new Color(Integer.parseInt(this.settings.getProperty(SettingsControl.getKey(content, SettingsControl.PURPOSE.marker), "0")), true);
    }

    @Override
    public Color getColor(@Nonnull ColorSetting colorSetting) {
        int rgba = Integer.parseInt(this.settings.getProperty(SettingsControl.getKey(colorSetting, SettingsControl.PURPOSE.color), "-1"));
        return rgba == -1 ? null : new Color(rgba, true);
    }

    @Override
    @Nullable
    public Object getSetting(String setting) {
        for (ObjectSetting<?> objectSetting : this.getAllObjectSettingNames()) {
            if (!objectSetting.name().equalsIgnoreCase(setting)) continue;
            return objectSetting.getObject(this.settings.getProperty(objectSetting.getTyp() + objectSetting.name()));
        }
        throw new IllegalArgumentException("Missing Plugins or invalid Setting");
    }

    @Override
    public void setSetting(@Nullable Object value, String setting) {
        List<ObjectSetting<?>> allObjectSettingNames = this.getAllObjectSettingNames();
        for (ObjectSetting<?> objectSetting : allObjectSettingNames) {
            try {
                ObjectSetting<?> set = objectSetting;
                if (!objectSetting.name().equalsIgnoreCase(setting)) continue;
                if (value == null) {
                    this.settings.remove(objectSetting.getTyp() + objectSetting.name());
                } else {
                    this.settings.put(objectSetting.getTyp() + objectSetting.name(), set.getAsString(value));
                }
                return;
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        throw new IllegalArgumentException("Missing Plugins or invalid Setting. Current setting = " + setting);
    }

    @Override
    @Nonnull
    public Settings copy() {
        DefaultSetting setting = new DefaultSetting();
        setting.settings.putAll((Map<?, ?>)this.settings);
        return setting;
    }

    @Override
    @Nonnull
    public Color getOutlineColor(DiffGroup.GroupType content) {
        return this.getColor(content);
    }

    Properties getSettings() {
        return this.settings;
    }
}

