/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.JsonException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class JsonWriter {
    private final Appendable writer;

    JsonWriter(Appendable writer) {
        this.writer = writer;
    }

    void writeValue(Object obj) throws IOException {
        if (obj == null) {
            this.writer.append("null");
        } else {
            ClassWrapper wrapper = ClassWrapper.getWrapper(obj.getClass());
            switch (wrapper.getJsonType()) {
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.writer.append(String.valueOf(obj));
                    break;
                }
                case 2: 
                case 16: {
                    this.writeQuoteString(obj.toString());
                    break;
                }
                case 3: {
                    this.writeCollection((Collection)obj);
                    break;
                }
                case 4: {
                    this.writeMap((Map)obj);
                    break;
                }
                case 5: 
                case 17: {
                    this.writeArray(obj);
                    break;
                }
                case 6: {
                    this.writeQuoteString(((Enum)obj).name());
                    break;
                }
                case 8: {
                    this.writer.append(Long.toString(((Date)obj).getTime()));
                    break;
                }
                default: {
                    this.writeObject(obj, wrapper);
                }
            }
        }
    }

    private void writeObject(Object obj, ClassWrapper wrapper) throws IOException {
        boolean isFirst = true;
        this.writer.append('{');
        Field[] fields = wrapper.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = fields[i];
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.writer.append(',');
                }
                this.writeQuoteString(field.getName());
                this.writer.append(':');
                this.writeValue(field.get(obj));
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (StackOverflowError ex) {
                JsonException jsonEx = new JsonException(String.valueOf(obj));
                jsonEx.setStackTrace(new StackTraceElement[0]);
                ex.addSuppressed(jsonEx);
                if (ex.getSuppressed().length == 0) {
                    StackOverflowError ex2 = new StackOverflowError(ex.getMessage());
                    ex2.addSuppressed(jsonEx);
                    if (ex2.getSuppressed().length > 0) {
                        ex2.setStackTrace(ex.getStackTrace());
                        throw ex2;
                    }
                }
                throw ex;
            }
        }
        this.writer.append('}');
    }

    private void writeArray(Object array) throws IOException {
        boolean isFirst = true;
        int length = Array.getLength(array);
        this.writer.append('[');
        for (int i = 0; i < length; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.writer.append(',');
            }
            Object value = Array.get(array, i);
            this.writeValue(value);
        }
        this.writer.append(']');
    }

    private void writeCollection(Collection<?> collection) throws IOException {
        boolean isFirst = true;
        this.writer.append('[');
        for (Object obj : collection) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.writer.append(',');
            }
            this.writeValue(obj);
        }
        this.writer.append(']');
    }

    private void writeMap(Map<?, ?> map) throws IOException {
        boolean isFirst = true;
        this.writer.append('{');
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.writer.append(',');
            }
            this.writeQuoteString(String.valueOf(entry.getKey()));
            this.writer.append(':');
            this.writeValue(entry.getValue());
        }
        this.writer.append('}');
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeQuoteString(String str) throws IOException {
        this.writer.append('\"');
        int length = str.length();
        int i = 0;
        while (true) {
            block11: {
                if (i >= length) {
                    this.writer.append('\"');
                    return;
                }
                char ch = str.charAt(i);
                switch (ch) {
                    case '\b': {
                        ch = 'b';
                        this.writer.append('\\');
                        break;
                    }
                    case '\f': {
                        ch = 'f';
                        this.writer.append('\\');
                        break;
                    }
                    case '\n': {
                        ch = 'n';
                        this.writer.append('\\');
                        break;
                    }
                    case '\r': {
                        ch = 'r';
                        this.writer.append('\\');
                        break;
                    }
                    case '\t': {
                        ch = 't';
                        this.writer.append('\\');
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        this.writer.append('\\');
                        break;
                    }
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\u000b': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': {
                        this.writer.append("\\u");
                        this.writer.append(Character.forDigit(ch >> 12 & 0xF, 16));
                        this.writer.append(Character.forDigit(ch >> 8 & 0xF, 16));
                        this.writer.append(Character.forDigit(ch >> 4 & 0xF, 16));
                        this.writer.append(Character.forDigit(ch & 0xF, 16));
                        break block11;
                    }
                }
                this.writer.append(ch);
            }
            ++i;
        }
    }
}

