/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.ElementList;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class Page
implements PagedElement,
Serializable {
    private int pageIndex;
    private float width;
    private float height;
    private int rotation;
    private ElementList list;
    private transient boolean inGetBounds;

    public Page(int pageIndex, float width, float height, int rotation) {
        this.pageIndex = pageIndex;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
        this.list = new ElementList(pageIndex);
    }

    public abstract BufferedImage getImage(int var1, int var2, @Nullable Rectangle2D var3, boolean var4, boolean var5);

    public void renderPage(@Nonnull Graphics2D graphics, Rectangle2D imgBounds) {
        BufferedImage image = this.getImage((int)Math.ceil(this.getWidth()), (int)Math.ceil(this.getHeight()), null, true, true);
        if (image != null) {
            graphics.drawImage((Image)image, 0, 0, null);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getRotation() {
        return this.rotation;
    }

    public AffineTransform getInitialTransform(double width, double height, Rectangle2D clip) {
        AffineTransform at = new AffineTransform();
        switch (this.getRotation()) {
            case 0: {
                at = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, height);
                break;
            }
            case 90: {
                at = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                break;
            }
            case 180: {
                at = new AffineTransform(-1.0, 0.0, 0.0, 1.0, width, 0.0);
                break;
            }
            case 270: {
                at = new AffineTransform(0.0, -1.0, -1.0, 0.0, width, height);
            }
        }
        if (clip == null) {
            clip = this.getBounds();
        }
        double scaleX = width / clip.getWidth();
        double scaleY = height / clip.getHeight();
        at.scale(scaleX, scaleY);
        at.translate(-clip.getMinX(), -clip.getMinY());
        return at;
    }

    public ElementList getElementList() {
        return this.list;
    }

    public abstract Exception getRecentError();

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.inGetBounds) {
            return null;
        }
        this.inGetBounds = true;
        try {
            Rectangle2D box = this.getPageBounds(PageBoundaries.CropBox);
            if (box != null) {
                Rectangle2D rectangle2D = box;
                return rectangle2D;
            }
            box = this.getPageBounds(PageBoundaries.MediaBox);
            if (box != null) {
                Rectangle2D rectangle2D = box;
                return rectangle2D;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            return float_;
        }
        finally {
            this.inGetBounds = false;
        }
    }

    @Override
    public ElementType getType() {
        return ElementType.Page;
    }

    @Override
    public String getLabel() {
        return "Page " + (this.getPageIndex() + 1);
    }

    public Rectangle2D getPageBounds(PageBoundaries ref) {
        return ref == PageBoundaries.MediaBox ? this.getBounds() : null;
    }

    public abstract void releaseResources();

    @InternalApi
    public static enum PageBoundaries {
        MediaBox,
        CropBox,
        BleedBox,
        TrimBox,
        ArtBox;

    }
}

