/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.i18n;

import com.inet.annotations.InternalApi;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@InternalApi
public class Msg {
    public static final String CONSOLE_HELP = "ConsoleTool.Help";
    public static final String CONSOLE_HELP_COMMAND = "ConsoleTool.Help.Command";
    public static final String CONSOLE_HELP_NET_COMMAND = "ConsoleTool.Help.NET.Command";
    public static final String NOT_EXIST = "Error.DoesNotExist";
    public static final String NOT_READABLE = "Error.CannotRead";
    public static final String NOT_DIRECTORY = "Error.NotDiretory";
    public static final String NAME_IS_NULL = "Error.NameIsNull";
    public static final String CONTENT_IS_NULL = "Error.ContentIsNull";
    public static final String IS_DIRECTORY = "Error.IsDiretory";
    public static final String MUST_BE_EQUAL_TYPES = "Error.ParametersMustBeEqualTypes";
    public static final String NO_CORRESPONDING_FILE_FOUND = "Error.NoCorrespondingFileFound";
    public static final String SCANNING = "Status.Scanning";
    public static final String FINISHED = "Status.finished";
    public static final String NO_DIFFERENCES_FOUND = "Status.NoDifferencesFound";
    public static final String DIFFERENCES_FOUND = "Status.DifferencesFound";
    public static final String MORE_DIFFERENCES = "Status.MoreDifferences";
    public static final String IMAGE_MISSING_IN_NEW = "module.image.diff.ImageMissingInNew";
    public static final String NEW_IMAGE = "module.image.diff.NewImage";
    public static final String WRONG_IMAGE_SIZE = "module.image.diff.WrongImageSize";
    public static final String LINE_MISSING_IN_NEW = "module.lines.diff.missingLineInNew";
    public static final String LINE_NEW = "module.lines.diff.newLine";
    public static final String CURVE_MISSING_IN_NEW = "module.lines.diff.missingCurveInNew";
    public static final String CURVE_NEW = "module.lines.diff.newCurve";
    public static final String RESULT_SUMMARY = "Status.ResultSummary";
    public static final String RESULT_SUMMARY_HEADER1 = "Status.ResultSummaryH1";
    public static final String RESULT_SUMMARY_HEADER2 = "Status.ResultSummaryH2";
    public static final String RESULT_SUMMARY_REMOVED = "Status.ResultSummaryRemoved";
    public static final String RESULT_SUMMARY_ADDED = "Status.ResultSummaryAdded";
    public static final String REQUESTING_TRIAL = "License.RequestingTrial";
    public static final String LICENSE_IS_TRIAL = "License.IsTrial";
    public static final String TRIAL_RUNNING = "License.TrialRunning";
    public static final String LICENSE_EXPIRED = "License.Expired";
    public static final String LICENSE_BETA_EXPIRED = "License.BetaExpired";
    public static final String LICENSE_NO_CONN = "License.NoConn";
    public static final String LICENSE_NO_CONN_CONSOLE = "License.NoConnConsole";
    public static final String LICENSE_ACTIVATION_KEY = "License.ActivationKey";
    public static final String LICENSE_UID = "License.UID";
    public static final String LICENSE_VALID = "License.Valid";
    public static final String LICENSE_INVALID = "License.Invalid";
    public static final String LICENSE_LICENSE_KEY_INVALID = "License.LicenseKeyInvalid";
    public static final String LICENSE_ACTIVATION_KEY_INVALID = "License.ActivationKeyInvalid";
    public static final String LICENSE_ACTIVATED = "License.Activated";
    public static final String LICENSE_NOT_SERVER = "License.NotServer";
    public static final String LICENSE_NOT_API = "License.NotAPI";
    public static final String LICENSE_NOT_COMMANDLINE = "License.NotCommandline";
    public static final String LICENSE_WRITE_FAILED = "License.FailedToWrite";
    public static final String CONSOLE_DIFF_OUTPUTLOCATION = "Console.SummaryOutputFolder";

    private static ResourceBundle getResourceBundle() {
        ResourceBundle languageResourcesTmp;
        try {
            languageResourcesTmp = ResourceBundle.getBundle("com.inet.pdfc.i18n.LanguageResources");
        }
        catch (MissingResourceException e) {
            languageResourcesTmp = null;
        }
        return languageResourcesTmp;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.inet.pdfc.i18n.LanguageResources", locale);
    }

    public static String getMsg(String msgID) {
        String msg;
        try {
            msg = Msg.getResourceBundle().getString(msgID);
        }
        catch (Throwable e) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static String getMsg(String msgID, Object ... msgParameter) {
        int i;
        StringBuffer msgBuf;
        String msg;
        if (msgParameter == null) {
            return Msg.getMsg(msgID);
        }
        ResourceBundle bundle = Msg.getResourceBundle();
        if (msgParameter.length > 0 && msgParameter[0] instanceof Locale) {
            bundle = Msg.getResourceBundle((Locale)msgParameter[0]);
        }
        try {
            msg = bundle.getString(msgID);
        }
        catch (Throwable e) {
            msgBuf = new StringBuffer();
            msgBuf.append(msgID);
            msgBuf.append('(');
            for (i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append('{');
                msgBuf.append(i);
                msgBuf.append('}');
            }
            msgBuf.append(')');
            msg = "$" + MessageFormat.format(msgBuf.toString(), msgParameter) + "$";
        }
        try {
            msg = MessageFormat.format(msg, msgParameter);
        }
        catch (Throwable t) {
            msgBuf = new StringBuffer();
            msgBuf.append('$').append(t.toString()).append('_').append(msgID).append('(');
            for (i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append(msgParameter[i]);
            }
            msgBuf.append(')').append('$');
            msg = msgBuf.toString();
        }
        return msg;
    }
}

