/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.model.AnnotationElement;
import java.awt.Rectangle;
import java.util.Date;

@JsonData
public class AnnotationHighlight
extends HighlightData.Highlight {
    private String author;
    private AnnotationElement.STATE state;
    private AnnotationElement.STATE_MODEL stateModel;
    private String subject;
    private int id;
    private int irtID;
    private Date date;
    private boolean isVisible = true;

    private AnnotationHighlight() {
    }

    public AnnotationHighlight(Rectangle bounds, AnnotationElement annotation) {
        super(bounds.x, bounds.y, bounds.width, bounds.height, annotation.getLabel(), AnnotationHighlight.getHighlightAppearance(annotation), annotation.getColor());
        this.author = annotation.getAuthor();
        this.state = annotation.getReviewState();
        this.stateModel = annotation.getReviewStateModel();
        this.subject = annotation.getSubject();
        this.id = annotation.getID();
        this.irtID = annotation.getReplyToID();
        this.date = annotation.getCreationDate();
    }

    @Override
    public String toString() {
        return "Annotation: " + this.getCaption() + "\nAuthor    : " + this.author + "\nState     : " + (Object)((Object)this.stateModel) + ", " + (Object)((Object)this.state) + "\nID        : " + this.id + "\nReplyToID : " + this.irtID;
    }

    public Date getCreationDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getId() {
        return this.id;
    }

    public int getIrtID() {
        return this.irtID;
    }

    public AnnotationElement.STATE getState() {
        return this.state;
    }

    public AnnotationElement.STATE_MODEL getStateModel() {
        return this.stateModel;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public final boolean isAnnotation() {
        return true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    private static HighlightData.Highlight.Appearance getHighlightAppearance(AnnotationElement anno) {
        if (anno.getBounds().isEmpty()) {
            return null;
        }
        String subtype = anno.getSubtype();
        if (subtype.equals("Highlight")) {
            return HighlightData.Highlight.Appearance.FILLED_RECTANGLE;
        }
        if (subtype.equals("StrikeOut")) {
            return HighlightData.Highlight.Appearance.STRIKEOUT;
        }
        if (subtype.equals("Underline")) {
            return HighlightData.Highlight.Appearance.UNDERLINE;
        }
        if (subtype.equals("Text") || subtype.equals("FreeText") || subtype.equals("Line") || subtype.equals("Circle") || subtype.equals("Square") || subtype.equals("Polygon") || subtype.equals("Caret") || subtype.equals("Stamp") || subtype.equals("Ink") || subtype.equals("PolyLine") || subtype.equals("Squiggly")) {
            return HighlightData.Highlight.Appearance.CUSTOM;
        }
        return null;
    }
}

