/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.results.painter.DiffConstants;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;

@InternalApi
public class SettingUtil {
    public static Set<ColorSetting> getAvailableColorSetting() {
        HashSet<ColorSetting> set = new HashSet<ColorSetting>();
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            set.add(groupType);
        }
        for (Enum enum_ : Settings.METAOPTION.values()) {
            set.add((ColorSetting)((Object)enum_));
        }
        return set;
    }

    public static Set<VisibilitySetting> getAvailableVisibilitySetting() {
        HashSet<VisibilitySetting> set = new HashSet<VisibilitySetting>();
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            set.add(groupType);
        }
        for (Enum enum_ : Settings.OPTION.values()) {
            set.add((VisibilitySetting)((Object)enum_));
        }
        for (Enum enum_ : Settings.EXPORT.values()) {
            set.add((VisibilitySetting)((Object)enum_));
        }
        return set;
    }

    public static void setAllOutlineMarkerSetting(Color color, Settings settings) {
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            settings.setMarkerColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), DiffConstants.getMarkerColor(groupType).getAlpha()), groupType);
        }
    }

    public static Color hexToColor(String hex) {
        if (hex == null || hex.isEmpty()) {
            return null;
        }
        String checkHex = hex.replace("#", "").toLowerCase();
        if (checkHex.matches("[0-9a-f]+")) {
            if (checkHex.length() == 6) {
                return new Color(Integer.valueOf(checkHex.substring(0, 2), 16), Integer.valueOf(checkHex.substring(2, 4), 16), Integer.valueOf(checkHex.substring(4, 6), 16));
            }
            if (checkHex.length() == 8) {
                return new Color(Integer.valueOf(checkHex.substring(0, 2), 16), Integer.valueOf(checkHex.substring(2, 4), 16), Integer.valueOf(checkHex.substring(4, 6), 16), Integer.valueOf(checkHex.substring(6, 8), 16));
            }
        }
        return null;
    }
}

