/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ModificationFormatter {
    public String format(Modification m) {
        String modifications;
        Modification.ModificationType modType;
        if (m == null) {
            return null;
        }
        boolean isText = m.getContentType().getBaseType() == ElementType.Text;
        List<PagedElement> first = m.getAffectedElements(true);
        List<PagedElement> second = m.getAffectedElements(false);
        String plural = (first.size() > 1 || second.size() > 1) && !isText && !m.isShouldPageElementMerge() ? ".plural" : ".singular";
        String prefix = Msg.getMsg("Prefix." + m.getContentType().getBaseType() + plural);
        String contentFirst = this.getContent(first, isText);
        String contentSecond = this.getContent(second, isText);
        AttributeDifference<?> locationChange = isText ? this.getLocationChange(m) : null;
        Modification.ModificationType modificationType = modType = locationChange != null ? Modification.ModificationType.attributeDifference : m.getModificationType();
        if (m.isShouldPageElementMerge()) {
            ArrayList<PagedElement> pagedElements;
            if (!first.isEmpty()) {
                pagedElements = new ArrayList<PagedElement>();
                pagedElements.add(first.get(0));
                contentFirst = this.getContent(pagedElements, isText);
            }
            if (!second.isEmpty()) {
                pagedElements = new ArrayList();
                pagedElements.add(second.get(0));
                contentSecond = this.getContent(pagedElements, isText);
            }
            return Msg.getMsg("Modification." + (Object)((Object)modType) + plural, prefix, contentFirst, contentSecond, "");
        }
        List<AttributeDifference<?>> changes = m.getAttributeDifferences();
        if (locationChange != null) {
            changes = new ArrayList(changes);
            changes.remove(locationChange);
            changes.add(locationChange);
            modifications = this.getModifications(changes);
            String position = this.getPosition(first, second);
            modifications = modifications + position;
        } else {
            modifications = this.getModifications(changes);
        }
        return Msg.getMsg("Modification." + (Object)((Object)modType) + plural, prefix, contentFirst, contentSecond, modifications);
    }

    private AttributeDifference<?> getLocationChange(Modification m) {
        if (m.getAttributeDifferences() != null && m.getAttributeDifferences().size() > 0) {
            for (AttributeDifference<?> d : m.getAttributeDifferences()) {
                if (!"TextLocationDiff".equals(d.getClass().getSimpleName())) continue;
                return d;
            }
        }
        return null;
    }

    protected String getModifications(List<AttributeDifference<?>> modificationList) {
        String modifications = "";
        if (modificationList != null && modificationList.size() > 0) {
            StringBuilder modBuilder = new StringBuilder();
            for (AttributeDifference<?> mod : modificationList) {
                if (modBuilder.length() > 0) {
                    modBuilder.append(", ");
                }
                modBuilder.append(mod.getMessage());
            }
            modifications = modBuilder.toString();
        }
        return modifications;
    }

    protected String getContent(List<PagedElement> elements, boolean isText) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        String concatString = isText ? " " : ", ";
        StringBuilder content = new StringBuilder();
        for (PagedElement e : elements) {
            if (content.length() > 0) {
                content.append(concatString);
            }
            content.append(e.getLabel());
        }
        return content.toString();
    }

    private String getPosition(List<PagedElement> elements, List<PagedElement> elements2) {
        if (elements == null || elements.size() == 0 || elements2 == null || elements2.size() == 0) {
            return "";
        }
        int precise = 3;
        String concatString = " ( ";
        Rectangle2D bounds = elements.get(0).getBounds();
        BigDecimal x1 = new BigDecimal(bounds.getX());
        BigDecimal y1 = new BigDecimal(bounds.getY());
        bounds = elements2.get(0).getBounds();
        BigDecimal x2 = new BigDecimal(bounds.getX());
        BigDecimal y2 = new BigDecimal(bounds.getY());
        concatString = concatString + x1.setScale(precise, 4) + " : " + y1.setScale(precise, 4) + " ) -> ( ";
        concatString = concatString + x2.setScale(precise, 4) + " : " + y2.setScale(precise, 4) + " )";
        return concatString;
    }
}

