/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client;

import com.inet.pdfc.remote.client.RPCClient;
import com.inet.pdfc.remote.client.ServiceDiscovery;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class PdfcServerInfo {
    private static final String DEFAULT_URL = "http://localhost:9900/pdfcrpcws";
    private String servicePath;
    private String cookie;
    private String user;
    private String password;

    void init() throws IOException {
        if (this.cookie == null) {
            URL url = new URL(this.getServicePath());
            RPCClient.getLogger().info("Login to " + url);
            URLConnection conn = url.openConnection();
            if (this.user != null) {
                PdfcServerInfo.setAuthorization(conn, this.user, this.password);
            }
            if (((HttpURLConnection)conn).getResponseCode() == 401 && this.user == null) {
                this.cookie = PdfcServerInfo.readCookie(conn);
                conn = url.openConnection();
                PdfcServerInfo.setAuthorization(conn, System.getProperty("user.name"), "");
                PdfcServerInfo.setCookie(conn, this.cookie);
            }
            try {
                conn.getInputStream();
                this.cookie = PdfcServerInfo.readCookie(conn);
            }
            catch (IOException ex) {
                this.cookie = null;
                throw ex;
            }
        }
    }

    private static String readCookie(URLConnection conn) {
        int idx;
        String cookie = conn.getHeaderField("Set-Cookie");
        if (cookie != null && (idx = cookie.indexOf(59)) > 0) {
            cookie = cookie.substring(0, idx);
        }
        return cookie;
    }

    private static void setCookie(URLConnection conn, String cookie) {
        if (cookie != null) {
            conn.setRequestProperty("Cookie", cookie);
        }
    }

    private static void setAuthorization(URLConnection conn, String user, String password) {
        conn.setRequestProperty("Authorization", "Basic " + Base64.getMimeEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8)));
    }

    public void setServicePath(String servicePath) {
        if (servicePath != null) {
            if (servicePath.indexOf("://") < 0) {
                servicePath = "http://" + servicePath;
            }
            try {
                String path = new URL(servicePath).getPath();
                if (path.isEmpty()) {
                    servicePath = servicePath + "/pdfcrpcws";
                } else if (path.equals("/")) {
                    servicePath = servicePath + "pdfcrpcws";
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.servicePath = servicePath;
        this.cookie = null;
    }

    public void setCredentials(String user, String password) {
        this.user = user;
        this.password = password == null ? "" : password;
        this.cookie = null;
    }

    public String getServicePath() {
        if (this.servicePath == null) {
            this.servicePath = DEFAULT_URL;
            try {
                String path = new ServiceDiscovery().getAnyServiceLocation();
                if (path != null) {
                    this.servicePath = path;
                }
            }
            catch (IOException e) {
                RPCClient.getLogger().error(e);
            }
        }
        return this.servicePath;
    }

    public String getCookie() {
        return this.cookie;
    }
}

