/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;

public class MDNSInputStream
extends ByteArrayInputStream {
    private Map<Integer, String> nameMap = new HashMap<Integer, String>();

    public MDNSInputStream(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public int readUnsignedShort() {
        return this.read() << 8 | this.read();
    }

    public int readInt() {
        return this.readUnsignedShort() << 16 | this.readUnsignedShort();
    }

    public byte[] readBytes(int len) {
        byte[] bytes = new byte[len];
        this.read(bytes, 0, len);
        return bytes;
    }

    public String readUTF(int len) {
        StringBuilder buffer = new StringBuilder(len);
        for (int index = 0; index < len; ++index) {
            int ch = this.read();
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    ch = (ch & 0x1F) << 6 | this.read() & 0x3F;
                    ++index;
                    break;
                }
                case 14: {
                    ch = (ch & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F;
                    ++index;
                    ++index;
                    break;
                }
                default: {
                    ch = (ch & 0x3F) << 4 | this.read() & 0xF;
                    ++index;
                }
            }
            buffer.append((char)ch);
        }
        return buffer.toString();
    }

    protected synchronized int peek() {
        return this.pos < this.count ? this.buf[this.pos] & 0xFF : -1;
    }

    public String readName() {
        HashMap<Integer, StringBuilder> names = new HashMap<Integer, StringBuilder>();
        StringBuilder buffer = new StringBuilder();
        boolean finished = false;
        while (!finished) {
            int len = this.read();
            if (len == 0) {
                finished = true;
                break;
            }
            if ((len & 0xC0) == 0) {
                int offset = this.pos - 1;
                String label = this.readUTF(len) + ".";
                buffer.append(label);
                for (StringBuilder previousLabel : names.values()) {
                    previousLabel.append(label);
                }
                names.put(offset, new StringBuilder(label));
                continue;
            }
            int index = (len & 0x3F) << 8 | this.read();
            String compressedLabel = this.nameMap.get(index);
            if (compressedLabel == null) {
                compressedLabel = "";
            }
            buffer.append(compressedLabel);
            for (StringBuilder previousLabel : names.values()) {
                previousLabel.append(compressedLabel);
            }
            finished = true;
        }
        for (Integer index : names.keySet()) {
            this.nameMap.put(index, ((StringBuilder)names.get(index)).toString());
        }
        return buffer.toString();
    }
}

