/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.config.FilterType;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.HighlightData;
import java.util.HashMap;
import java.util.List;

@JsonData
@InternalApi
public class BasicHighlightDataImpl
implements HighlightData {
    private static final long serialVersionUID = -2653628220557974408L;
    private String type;
    private HashMap<Integer, List<HighlightData.Highlight>> first = new HashMap();
    private HashMap<Integer, List<HighlightData.Highlight>> second = new HashMap();
    private int newHeader;
    private int newFooter;

    public BasicHighlightDataImpl() {
    }

    protected BasicHighlightDataImpl(String type) {
        this.type = type;
    }

    protected BasicHighlightDataImpl(String type, int newHeader, int newFooter) {
        this.type = type;
        this.newHeader = newHeader;
        this.newFooter = newFooter;
    }

    protected BasicHighlightDataImpl(String type, BasicHighlightDataImpl other) {
        this.type = type;
        this.first = other.first;
        this.second = other.second;
        this.newFooter = other.newFooter;
        this.newHeader = other.newHeader;
    }

    public HashMap<Integer, List<HighlightData.Highlight>> getFirst() {
        return this.first;
    }

    public HashMap<Integer, List<HighlightData.Highlight>> getSecond() {
        return this.second;
    }

    public int getNewHeader() {
        return this.newHeader;
    }

    public int getNewFooter() {
        return this.newFooter;
    }

    @Override
    public List<HighlightData.Highlight> getPageHighlights(int pageNr, boolean firstDocument) {
        return (firstDocument ? this.first : this.second).get(pageNr);
    }

    @Override
    public FilterType getTypeKey() {
        try {
            return FilterType.valueOf(this.type);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getFilterKey() {
        return this.type;
    }

    public final BasicHighlightDataImpl createCopy() {
        return new BasicHighlightDataImpl(this.type, this);
    }

    @Override
    public Chunk.ChunkType getType() {
        return Chunk.ChunkType.highlight;
    }
}

