/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.rpc.model;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.pdfc.rpc.model.EventCommand;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class JSONEvent {
    private EventCommand command;
    private String payload;

    private JSONEvent() {
    }

    public JSONEvent(@Nonnull EventCommand command, @Nullable Object payload) {
        this.command = command;
        this.payload = new Json().toJson(payload);
    }

    public static JSONEvent fromJSON(String json) {
        return new Json().fromJson(json, JSONEvent.class);
    }

    public static String toJSON(@Nonnull EventCommand command, @Nullable Object payload) {
        return new JSONEvent(command, payload).getJSON();
    }

    @Nonnull
    public EventCommand getCommand() {
        return this.command;
    }

    @Nullable
    public <T> T getPayload(@Nonnull Class<T> type) {
        return new Json().fromJson(this.payload, type);
    }

    @Nonnull
    public String getJSON() {
        return new Json().toJson(this);
    }
}

